/*
 * Created on 2004/08/06
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * IHTTPĎsm[h̃XgIɓǂŃL[PushThread
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadListReadQueuePushHTTPControl implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * IHTTPĎm[h̃XgIɓǂŃL[PushThread
     * NXCX^X𐶐܂B
     */
    public ThreadListReadQueuePushHTTPControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     *
     */
    public void run() {
        int count = 0;
        Iterator it = null;

        while (true) {
            // HTTPĎm[hXgǂݍ
            Map list = ListQueueHTTPControl.getInstance().getHTTPHashMap();

            for (it = list.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                NodeWatchInfo info = (NodeWatchInfo) list.get(key);

                if (info == null) {
                    continue;
                }

                NodeWatchInfo nodeInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());

                if (nodeInfo == null) {
                    continue;
                }

                // HTTPo
                count = Integer.parseInt(info.getCountHttpPeriod());

                if (count != 0) {
                    count--;
                    info.setCountHttpPeriod(Integer.toString(count));

                    if (count == 0) {
                        // HTTPsL[Push
                        QueueForHTTP.getInstance().pushQue(info);

                        // HTTPJE^Zbg
                        info.setCountHttpPeriod(info.getHttpPeriod());
                    }
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
