/*
 * Created on 2004/05/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;



/**
 * IɃm[hSNMPvMIB̎sm[hĎ񃊃Xgm[hIP
 * AhXL[ƂĕێASNMPvMIB̎sThread𐧌䂷
 * ߂̃XgێNXłB
 * ʃXbhł̃Xg̃JE^PbŃJEg_E0([)
 * ȂƎsL[Push܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ListQueueStatisticsMibControl {
    /* IPAhXKeyƂēv̎ێMap */
    private Map<String, StatisticsMibInfo> statisticsHashMap;

    /*
     * IPAhXL[Ƃm[hĎێMap𐶐
     * ܂B
     */
    private ListQueueStatisticsMibControl() {
        statisticsHashMap = Collections.synchronizedMap(new LinkedHashMap<String, StatisticsMibInfo>());
    }

    /**
     * w肳ꂽIPAhXL[ƂāAm[hSNMPv̎Ď
     * XV܂B
     *
     * @param ipAddress m[hIPAhX
     * @param statisticsNodeInfo SNMPvMIB̎
     */
    public void updateStatisticsMibGetNode(
        String ipAddress, StatisticsMibInfo statisticsNodeInfo) {
        // XgXV
        statisticsHashMap.put(ipAddress, statisticsNodeInfo);
    }

    /**
     * w肳ꂽIPAhXL[ƂāAm[hSNMPv̎Ď
     * MapɊi[܂B
     *
     * @param ipAddress m[hIPAhX
     * @param statisticsNodeInfo SNMPvMIB̎
     */
    public void setStatisticsMibGetNode(
        String ipAddress, StatisticsMibInfo statisticsNodeInfo) {
        // Xgɒǉ
        statisticsHashMap.put(ipAddress, statisticsNodeInfo);
    }

    /**
     * wm[hIPAhXSNMPvMIB̎Ԃ܂B
     *
     * @param ipAddress m[hIPAhX
     * @return SNMPvMIB̎
     */
    public StatisticsMibInfo getStatisticsMibGetNode(String ipAddress) {
        return (StatisticsMibInfo) statisticsHashMap.get(ipAddress);
    }

    /**
     * wm[hIPAhXSNMPvMIB̎폜܂B
     *
     * @param ipAddress m[hĎ
     */
    public void removeStatisticsMibGetNode(String ipAddress) {
        statisticsHashMap.remove(ipAddress);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ListQueueStatisticsMibControl getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * m[hSNMPvMIB̎ĎێMapԂ܂B
     *
     * @return m[hSNMPvMIB̎ĎێMap
     */
    public Map getStatisticsMibHashMap() {
        return statisticsHashMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ListQueueStatisticsMibControl DBPOOL =
            new ListQueueStatisticsMibControl();
    }
}
