/*
 * Created on 2004/07/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.holdperiod;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;


/**
 * A[f[^yѓv̕ێԃ`FbNyэős`FbNs
 * ThreadNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ThreadPeriodHoldCheck implements Runnable {
    /** Ďԁi60000ms = 60bj */
    public static final long WATCH_PERIOD = 60000;

    /* ێԓms(Pms)ϊ萔 */
    private static final long DIFF = 1000 * 60 * 60 * 24;

    /* fobOpێԒ萔30ԕێ3ԕێ */

    // private static final long DIFF = 1000 * 60; // 1min

    /* ThreadNwaitJE^ */
    private static final int WAIT_COUNT = 5;

    /* MO */
    private static Logger logger = null;
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /* \[X */
    private SystemResourceFileParse resourceset;

    /* f[^ێԃ`FbNThread */
    private Thread periodHoldCheckThread;

    // [vɂĊĎ邩ifobOpŊĎȂꍇfalsej
    private boolean isLoop = true;

    /**
     * f[^x[Xe[u̕ێԋyэős`FbNp
     * ThreadCX^X𐶐܂B
     */
    private ThreadPeriodHoldCheck() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^ێԃ`FbNThraedN܂B
     *
     */
    public void startThread() {
        periodHoldCheckThread = new Thread(SingletonResource.RESOURCE);
        periodHoldCheckThread.start();

        int wait = 0;

        while (!periodHoldCheckThread.isAlive()) {
            wait++;

            if (wait >= WAIT_COUNT) {
                break;
            }

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * f[^ێԃ`FbNThraed~܂B
     *
     */
    public void stopReceiving() {
        if (periodHoldCheckThread == null) {
            return;
        }

        // interrupt receive thread so it will die a natural death
        periodHoldCheckThread.interrupt();

        /* ێԃ`FbNThread~܂Loop */
        while (
            (periodHoldCheckThread != null) && periodHoldCheckThread.isAlive()) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                /* Stopw */
                logger.info("Stop pperiod hold check Thread " + e.getMessage());

                break;
            }
        }

        logger.info("PeriodHold Check Thread stop");
        periodHoldCheckThread = null;
    }

    /**
     * f[^x[Xe[u̕ێԋyэős`FbNp
     * ThreadłB
     *
     */
    public void run() {
        /* [vɂĊĎ */
        while (isLoop) {
            try {
                Thread.sleep(WATCH_PERIOD);

                checkData();
            } catch (InterruptedException e) {
                /* Stopw */
                logger.info("Stop pperiod hold check Thread " + e.getMessage());

                break;
            } catch (DatabaseConnectionException e3) {
                logger.warning(e3.getMessage());
                e3.printStackTrace();

                break;
            } catch (SQLException e3) {
                logger.warning(e3.getMessage());
                e3.printStackTrace();

                break;
            }
        }
    }

    /**
     * A[f[^yѓv̕ێԃ`FbNyэős`FbN
     * s܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV̎擾Ɏsꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void checkData() throws DatabaseConnectionException, SQLException {
        /* A[ős\[Xt@Cǂݍ */
        long lineNo = 0;
        resourceset =
            (SystemResourceConfig.getInstance()).getResourceFileParse();

        lineNo = Long.parseLong(resourceset.getResourceInfo().getAlarmMax());

        if (lineNo > 0) {
            // A[ős`FbN
            this.checkDataMaxLine(
                DBTableAlarm.ALARM_TABLE, DBTableAlarm.ALARM_DATE, lineNo);
        }

        /* A[ێԃ`FbN */
        Date date = Calendar.getInstance().getTime();
        long nowdate = date.getTime();
        long alarmHoldPeriod = 0;
        long statisticsHoldPeriod = 0;

        alarmHoldPeriod =
            Long.parseLong(
                resourceset.getResourceInfo().getAlarmHoldPeriodDay());

        if (alarmHoldPeriod != 0) {
            long diff = DIFF * alarmHoldPeriod;

            // Date validDate = new Date(nowdate - diff);
            Date validDate = Calendar.getInstance().getTime();
            validDate.setTime(nowdate - diff);

            // A[f[^e[uێԃ`FbN
            this.checkAlarmPeriodDate(validDate);
        }

        /* L𒊏o */
        statisticsHoldPeriod =
            Long.parseLong(
                resourceset.getResourceInfo().getStatisticsHoldPeriodDay());

        Date validDate = null;

        if (statisticsHoldPeriod != 0) {
            // ݓƗLێԂLZo
            long diff = DIFF * statisticsHoldPeriod;

            // validDate = new Date(nowdate - diff);
            validDate = Calendar.getInstance().getTime();
            validDate.setTime(nowdate - diff);
        }

        /* ős𒊏o */
        lineNo = 0;
        resourceset =
            (SystemResourceConfig.getInstance()).getResourceFileParse();

        lineNo =
            Long.parseLong(resourceset.getResourceInfo().getStatisticsMax());

        // vf[^e[uێԂƍős`FbN
        this.checkStatisticsTable(validDate, lineNo);
    }

    /**
     * A[f[^̕ێԂ`FbN܂B
     *
     * @param checkDate ێ
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void checkAlarmPeriodDate(final Date checkDate)
        throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            String sql =
                "SELECT * from " + DBTableAlarm.ALARM_TABLE + " where "
                + DBTableAlarm.ALARM_DATE + " <= '"
                + dateformat.format(checkDate) + "'";

            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
                System.out.print(
                    rs.getObject(DBTableAlarm.ALARM_DATE).toString() + "  ");
                System.out.println(
                    rs.getObject(DBTableAlarm.ALARM_MESSAGE).toString());
            }

            sql = "DELETE from " + DBTableAlarm.ALARM_TABLE + " where "
                + DBTableAlarm.ALARM_DATE + " <= '"
                + dateformat.format(checkDate) + "'";

            // select̎s
            stmt.execute(sql);
        } catch (DatabaseConnectionException ex) {
            ex.printStackTrace();
            throw ex;
        } catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                dataaccess.releaseConnection(conn);

                // conn.close();
                conn = null;
            }

            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }
    }

    /**
     * w̃f[^e[uiA[f[^e[u܂́Av
     * f[^e[uj̍ős`FbN܂B
     *
     * @param tableName `FbNΏۃe[u
     * @param columnName Ƀ\[g邽߂̗
     * @param limitLineNo Lős
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void checkDataMaxLine(
        final String tableName, final String columnName, final long limitLineNo)
        throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        // ArrayList alarmIDList = null;
        long lineCount = 0;
        String sql = "";
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            sql = "select count(*) from " + tableName;

            // select̎s
            rs = stmt.executeQuery(sql);
            rs.next();

            long count = -1;
            count = rs.getLong(1);
            lineCount = count;

            /* while (rs.next()) {
                if (
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                 .equals(
                            DataAccessObject.POSTGRESQL)) {
                    System.out.println(
                        "table count : " + rs.getObject(DataAccessObject.POSTGRESQL_COUNT_COLUMN));
                    lineCount =
                        Long.parseLong(rs.getObject(DataAccessObject.POSTGRESQL_COUNT_COLUMN).toString());
                } else {
                    System.out.println(
                        "table count : " + rs.getObject("count(*)"));
                    lineCount =
                        Long.parseLong(rs.getObject("count(*)").toString());
                }
            } */
            if (lineCount > limitLineNo) {
                sql = "SELECT * from " + tableName + " order by " + columnName
                    + " desc";

                // select̎s
                rs = stmt.executeQuery(sql);

                ArrayList alarmIDList = new ArrayList();

                while (rs.next()) {
                    alarmIDList.add(
                        rs.getObject(DBTableAlarm.ALARM_ID).toString());
                }

                for (int i = 0; i < alarmIDList.size(); i++) {
                    if (i >= limitLineNo) {
                        sql = "DELETE from " + tableName + " where "
                            + DBTableAlarm.ALARM_ID + " = '"
                            + alarmIDList.get(i) + "'";

                        // select̎s
                        stmt.execute(sql);
                    }
                }
            }
        } catch (DatabaseConnectionException ex) {
            logger.warning(
                "DatabaseConnectionException SQL=" + sql + " "
                + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } catch (SQLException ex) {
            logger.warning("SQLException SQL=" + sql + " " + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                dataaccess.releaseConnection(conn);

                // conn.close();
                conn = null;
            }

            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }
    }

    /**
     * vf[^̕ێԂƍős`FbN܂B
     *
     * @param checkDate ێL
     * @param limitLineNo Lős
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void checkStatisticsTable(
        final Date checkDate, final long limitLineNo)
        throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "";
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            sql = "SELECT * from " + DBTableManagement.TABLEMANAGEMENT + " "
                + "where " + DBTableManagement.LIMIT_CHECK + "=" + "'"
                + DBTableManagement.LIMIT_YES + "'";

            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
                String tableName =
                    rs.getObject(DBTableManagement.TABLE_NAME).toString();

                if (checkDate != null) {
                    /* ێԃI[o[̍s폜 */
                    sql = "DELETE from " + tableName + " " + "where "
                        + AbstractDataAccessObject.CUR_DATE + " <= '"
                        + dateformat.format(checkDate) + "'";

                    // select̎s
                    dataaccess.executeUpdate(sql);
                }

                if (limitLineNo > 0) {
                    // vős`FbN
                    this.checkDataMaxLine(
                        tableName, AbstractDataAccessObject.CUR_DATE,
                        limitLineNo);
                }
            }
        } catch (DatabaseConnectionException ex) {
            logger.warning(
                "DatabaseConnectionException SQL=" + sql + " "
                + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } catch (SQLException ex) {
            logger.warning("SQLException SQL=" + sql + " " + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
            }

            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ThreadPeriodHoldCheck getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * f[^ێԃ`FbNThreadԂ܂B
     *
     * @return periodHoldCheckThread f[^ێԃ`FbNThread
     */
    public Thread getPeriodHoldCheckThread() {
        return periodHoldCheckThread;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ThreadPeriodHoldCheck RESOURCE =
            new ThreadPeriodHoldCheck();
    }
}
