/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsData;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * m[hMapł̃m[hIconIj[ŁASNMPve[u\I
 * ꍇ s郁\bhSelectionAdapterNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapMenuNodeSnmpStatisticsTable extends SelectionAdapter {
    /* MO */
    private static Logger logger;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /**
     * SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    protected boolean isSocket;

    /* SNMPvf[^e[u\OID */
    private String oid;

    /**
     * m[hMapł̃m[hIconIj[ŁASnmpve[u\
     * IꍇɎs郁\bhSelectionAdapter
     * NXCX^X𐶐܂B
     *
     * @param nodeInfo m[hĎ
     * @param isSocket SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     * @param oid OID
     */
    public NodeMapMenuNodeSnmpStatisticsTable(
        NodeInformation nodeInfo, boolean isSocket, String oid) {
        logger = Logger.getLogger(this.getClass().getName());
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
        this.oid = oid;
    }

    /**
     * SNMPve[u\IłB
     * 
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {

        String nodeName =
            nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            activePage.openEditor(
                new EditorInputNodeView(
                    nodeName + EditorNodeSnmpStatisticsData.TITLE_SUFFIX
                    + " OID=" + oid, nodeInfo, isSocket, oid),
                EditorNodeSnmpStatisticsData.class.getName());
        } catch (PartInitException e3) {
            logger.warning(e3.getMessage());
            e3.printStackTrace();
        }
    }
}
