/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeConfig;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * SelectionAdapterpAm[hMapIconIŃm[hView Open
 * j[Ĩ\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapMenuNodeConfig extends SelectionAdapter {
    /* MO */
    private static Logger logger;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /*
     * SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    protected boolean isSocket;

    /**
     * SelectionAdapterpAm[hMapIconIŃm[hView Open
     * j[Ĩ\bhNXCX^X𐶐܂B
     *
     * @param nodeInfo m[hĎ
     * @param isSocket SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    public NodeMapMenuNodeConfig(NodeInformation nodeInfo, boolean isSocket) {
        logger = Logger.getLogger(this.getClass().getName());
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
    }

    /**
     * j[IłB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String nodeName =
            nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

        try {
            activePage.openEditor(
                new EditorInputNodeView(
                    nodeName + EditorNodeConfig.TITLE_SUFFIX, nodeInfo, isSocket),
                EditorNodeConfig.class.getName());
        } catch (PartInitException e3) {
            logger.warning(e3.getMessage());
            e3.printStackTrace();
        }
    }
}
