/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.alarm.EditorNodeAlarm;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * m[hMapł̃m[hIconIj[ŁAAlarm\Iꍇ
 * s郁\bhSelectionAdapterNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapMenuNodeAlarm extends SelectionAdapter {
    /* MO */
    private static Logger logger;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /*
     * SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    protected boolean isSocket;

    /**
     * m[hMapł̃m[hIconIj[ŁAAlarm\I
     * ꍇɎs郁\bhSelectionAdapterNX
     * CX^X𐶐܂B
     *
     * @param nodeInfo m[hĎ
     * @param isSocket lbg[NoR̎tO
     */
    public NodeMapMenuNodeAlarm(NodeInformation nodeInfo, boolean isSocket) {
        logger = Logger.getLogger(this.getClass().getName());
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
    }

    /**
     * m[hMapł̃m[hIconIj[ŁAAlarm\I
     * ꍇɋN郁\bhłB
     *
     * @param e SelectionEvent
     */
    public void widgetSelected(SelectionEvent e) {
        String nodeName =
            nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            /*
            * IꂽGg̃m[hURLEditorɃuEU
            * I[v
            */
            activePage.openEditor(
                new EditorInputNodeView(
                    nodeName + EditorNodeAlarm.TITLE_SUFFIX, nodeInfo, isSocket),
                EditorNodeAlarm.class.getName());
        } catch (PartInitException e3) {
            logger.warning(e3.getMessage());
            e3.printStackTrace();
        }
    }
}
