/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;



/**
 * f[^CSVo͂ANVNXNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderDataExport {
    /* MO */
    private static Logger logger;

    /* Alarm CSV ExportANV */
    private IAction exportAlarmAction = new ActionExportAlarm();

    /* m[hSnmpv CSV ExportANV */
    private IAction exportSnmpStatisticsAction =
        new ActionExportSnmpStatisticsData();

    /* m[hPingf[^ CSV ExportANV */
    private IAction exportPingResponseAction = new ActionExportPingResponse();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * AlarmXge[uViewɊւANVNX
     * CX^X𐶐܂B
     *
     */
    public ActionBuilderDataExport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Alarm CSV ExportANVԂ܂B
     *
     * @return Alarm CSV ExportANV
     */
    public IAction getActionExportAlarm() {
        return exportAlarmAction;
    }

    /**
     * m[hSNMPvExportANVԂ܂B
     *
     * @return m[hSNMPvExportANV
     */
    public IAction getActionExportSnmpStatistics() {
        return exportSnmpStatisticsAction;
    }

    /**
     * m[hPingf[^ CSV ExportANVԂ܂B
     *
     * @return m[hPingf[^ CSV ExportANV
     */
    public IAction getActionExportPing() {
        return exportPingResponseAction;
    }

    /**
     * A[e[uXV܂B
     *
     */
    protected void refreshNodeAlarmTable() {
    }

    /*
     * wTableAlarmwFileɏo͂܂B
     *
     * @param csvFile
     * @param table
     */
    private void writeCSVFile(final String csvFile, Table table) {
        if ((csvFile == null) || csvFile.equals("") || (table == null)) {
            return;
        }

        FileOutputStream fo = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;

        try {
            fo = new FileOutputStream(csvFile);
            osw = new OutputStreamWriter(fo);
            bw = new BufferedWriter(osw);

            ArrayList tableDataList = getTableData(table);

            if (tableDataList != null) {
                System.out.println(
                    "tableDataList.size() : " + tableDataList.size());

                for (int j = 0; j < tableDataList.size(); j++) {
                    String[] tableData = (String[]) tableDataList.get(j);

                    StringBuffer buf = new StringBuffer();

                    for (int k = 0; k < tableData.length; k++) {
                        System.out.println("data : " + tableData[k]);
                        buf.append(tableData[k] + ",");
                    }

                    System.out.println("data buf : " + buf.toString());
                    bw.write(buf.toString());
                    bw.newLine();
                    bw.flush();
                }
            } else {
                System.out.println("tableDataList null");
            }
        } catch (FileNotFoundException e) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Alarm List import error", e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            /* t@Co͂Ɏs */
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Alarm List import error", e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            e.printStackTrace();

            return;
        } finally {
            // CSVGNX|[gš㏈
            if (bw != null) {
                try {
                    bw.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }

            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }

            if (fo != null) {
                try {
                    fo.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }
        }
    }

    /*
     * wTablef[^𒊏oAListɊi[ĕԂ܂B
     *
     * @param table
     * @return tableDataList Tablef[^i[List
     */
    private ArrayList getTableData(Table table) {
        ArrayList<Object> tableDataList = new ArrayList<Object>();

        TableItem[] items = table.getItems();

        /* Ae[uRowColumnf[^擾 */
        for (int i = 0; i < items.length; i++) {
            tableDataList.add(items[i].getData());
        }

        return tableDataList;
    }

    /**
     * Alarm Liste[uViewɊւANVNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractExportAction extends Action {
        /**
         *
         */
        public final void run() {
            doTask();
        }

        protected abstract void doTask();
    }

    /**
     * AlarmCSVo͂ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     *
     */
    public class ActionExportAlarm extends AbstractExportAction {
        private Table table;

        /**
         * AlarmCSVo͂ANṼACRImageDescriptorԂ܂B
         *
         * @return AlarmCSVo͂ANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/export_wiz.gif"));
        }

        /**
         * AlarmCSVo͂ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Export alarm table";
        }

        /**
         * AlarmCSVo͂ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "AlarmCSVo͂܂";
        }

        /**
         * AlarmCSVo͂܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, SWT.SAVE);
            String csvFile = openDialog.open();
            logger.info("Open file name : " + csvFile);

            if (csvFile == null) {
                return;
            }

            writeCSVFile(csvFile, table);
        }

        /**
         * A[e[uZbg܂B
         *
         * @param table A[e[u
         */
        public void setTable(Table table) {
            this.table = table;
        }
    }

    /**
     * PingCSVo͂ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     *
     */
    public class ActionExportPingResponse extends AbstractExportAction {
        private Table table;

        /**
         * PingCSVo͂ANṼACRImageDescriptorԂ܂B
         *
         * @return AlarmmFANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/export_wiz.gif"));
        }

        /**
         * PingCSVo͂ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Export ping response table";
        }

        /**
         * PingCSVo͂ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Ping response dataCSVo͂܂";
        }

        /**
         * PingCSVo͂܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, SWT.SAVE);
            String csvFile = openDialog.open();
            logger.info("Open file name : " + csvFile);

            if (csvFile == null) {
                return;
            }

            writeCSVFile(csvFile, table);
        }

        /**
         * @param table table ݒB
         */
        public void setTable(Table table) {
            this.table = table;
        }
    }

    /**
     * SnmpvCSVo͂ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     *
     */
    public class ActionExportSnmpStatisticsData extends AbstractExportAction {
        private Table table;

        /**
         * SnmpvCSVo͂ANṼACRImageDescriptorԂ܂B
         *
         * @return SnmpvCSVo͂ANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/export_wiz.gif"));
        }

        /**
         * SnmpvCSVo͂ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Export snmp statisticsdata table";
        }

        /**
         * SNMPvCSVo͂ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "SNMPvCSVo͂܂";
        }

        /**
         * SNMPvCSVo͂܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, SWT.SAVE);
            String csvFile = openDialog.open();
            logger.info("Open file name : " + csvFile);

            if (csvFile == null) {
                return;
            }

            writeCSVFile(csvFile, table);
        }

        /**
         * SNMPve[uZbg܂B
         *
         * @param table  SNMPve[u
         */
        public void setTable(Table table) {
            this.table = table;
        }
    }
}
