/*
 * Created on 2004/10/29
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsManager;
import netjfwatcher.engine.snmpmanager.process.SnmpV3UsmStatisticsInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpV3UsmStatisticsManager;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.snmp.EditorSnmpStatisticsInfo;


/**
 * SNMPvWĕԂ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandSnmpStatisticsInfo extends TemplateCommandImpl {
    /**
     * SNMPvMIB̎s܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        NodeInformation nodeInfo = com.getNodeInformation();

        /* SNMPvi[GA */
        String[] statisticsInfo =
            new String[EditorSnmpStatisticsInfo.COLUMN_HEADER.length];

        /*
         * ĎΏۃm[hZbg
         */
        statisticsInfo[EditorSnmpStatisticsInfo.IP_ADDRESS_POS] =
            nodeInfo.getIpaddress();
        statisticsInfo[EditorSnmpStatisticsInfo.NODE_NAME_POS] =
            nodeInfo.getNodename();

        String snmpLevel = nodeInfo.getSnmpLevel();

        if (snmpLevel.equals("0")) {
            statisticsInfo[EditorSnmpStatisticsInfo.SNMP_VERSION_POS] = "--";
        } else {
            statisticsInfo[EditorSnmpStatisticsInfo.SNMP_VERSION_POS] =
                nodeInfo.getSnmpVersion();
        }

        /* SNMP V1/V2v  */
        SnmpStatisticsInfo snmpInfo =
            SnmpStatisticsManager.getInstance().getSnmpStatisticsInfo(
                nodeInfo.getIpaddress());

        /* SNMP V3v */
        SnmpV3UsmStatisticsInfo snmpV3Info =
            SnmpV3UsmStatisticsManager.getInstance().getSnmpStatisticsInfo(
                nodeInfo.getIpaddress());

        statisticsInfo[EditorSnmpStatisticsInfo.SOCKET_TIMEOUT_POS] =
            Integer.toString(snmpInfo.getSnmpSocketTimeout());
        statisticsInfo[EditorSnmpStatisticsInfo.UNMUCH_REQUEST_ID_POS] =
            Integer.toString(snmpInfo.getSnmpUnmuchRequestID());
        statisticsInfo[EditorSnmpStatisticsInfo.ERROR_STATUS_POS] =
            Integer.toString(snmpInfo.getSnmpErrorStatus());
        statisticsInfo[EditorSnmpStatisticsInfo.UNMUCH_SNMPV3_MSG_ID_POS] =
            Integer.toString(snmpInfo.getSnmpV3UnmuchmsgID());

        /*
         * SNMP V3 USM(User based Security Model)v
         */
        statisticsInfo[EditorSnmpStatisticsInfo.USM_UNSUPPORT_LEVELS_POS] =
            Integer.toString(snmpV3Info.getUsmStatsUnsupportedSecLevels());
        statisticsInfo[EditorSnmpStatisticsInfo.USM_NOT_INTIME_WINDOWS] =
            Integer.toString(snmpV3Info.getUsmStatsNotInTimeWindows());
        statisticsInfo[EditorSnmpStatisticsInfo.USM_UNKNOWN_USERNAME] =
            Integer.toString(snmpV3Info.getUsmStatsUnknownUserNames());
        statisticsInfo[EditorSnmpStatisticsInfo.USM_UNKNOWN_ENGINE_ID] =
            Integer.toString(snmpV3Info.getUsmStatsUnknownEngineIDs());
        statisticsInfo[EditorSnmpStatisticsInfo.USM_WRONG_DIGESTS] =
            Integer.toString(snmpV3Info.getUsmStatsWrongDigests());
        statisticsInfo[EditorSnmpStatisticsInfo.USM_DECRYPTION_ERRORS] =
            Integer.toString(snmpV3Info.getUsmStatsDecryptionErrors());

        sendResponse(statisticsInfo, ois, oos);
    }
}
