/*
 * Created on 2004/04/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.MibGetResponse;
import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.preference.SnmpPreference;


/**
 *@MIB̎s܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandMibGet extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * MIB̎s܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        String mibGetResult = "OK";

        MibGetNextInfo mibGetInstance = null;

        ArrayList mibGetStatisticsList = new ArrayList();

        if (com.getMibInfo().getVersion() == SnmpPreference.SNMPV3) {
            /*
             * SNMP V3wɂMIB̎^[QbgSNMP V3o^
             * ꍇG[ʂʒm
             */
            if (
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3AgentInfo(com.getIpaddress()) == null) {
                mibGetResult =
                    "Not found SNMP V3 Agent Address = " + com.getIpaddress();
                logger.warning(mibGetResult);

                MibGetResponseList mibGetResponseList =
                    new MibGetResponseList();
                mibGetResponseList.setResultCode(mibGetResult);

                sendResponse(mibGetResponseList, ois, oos);

                return;
            }
        }

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        com.getIpaddress(), Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    com.getIpaddress(), "Command Mib Get", checkCount,
                    com.getMibInfo().getVersion());
            }

            mibGetInstance.setMibGetNext(
                com.getIpaddress(), com.getMibInfo().getVersion(),
                com.getMibInfo().getRoCommunity());

            mibGetStatisticsList =
                mibGetInstance.getNextMibValueList(com.getMibInfo().getRequestMibOid());
        } catch (UnknownHostException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            mibGetResult = e1.getMessage();
        } catch (SocketException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            mibGetResult = e1.getMessage();
        } catch (SnmpMIBGetException e1) {
            logger.warning(com.getIpaddress() + e1.getMessage());
            mibGetResult = e1.getMessage();
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    com.getIpaddress(), Thread.currentThread().getName());
            }
        }

        // ̎悵OIDXg
        MibGetResponseList mibGetResponseList = new MibGetResponseList();
        mibGetResponseList.setResultCode(mibGetResult);

        /* ̎OIDɍ̎挋ʁiMIB GetjXgɏi[ */
        for (int j = 0; j < mibGetStatisticsList.size(); j++) {
            MibGetResponse mibgetresponse = new MibGetResponse();

            // OIDɑΉMIB
            mibgetresponse.setMibName(
                ((MibValue) (mibGetStatisticsList.get(j))).getMibName());

            // OIDl
            mibgetresponse.setMibOid(
                ((MibValue) (mibGetStatisticsList.get(j))).getMibOid());

            // OIDɑΉl
            mibgetresponse.setMibValue(
                ((MibValue) (mibGetStatisticsList.get(j))).getMibValue());

            // OIDɑΉType
            mibgetresponse.setMibType(
                ((MibValue) (mibGetStatisticsList.get(j))).getMibType());

            // OIDɑΉANZX^Cv
            mibgetresponse.setMibAccess(
                ((MibValue) (mibGetStatisticsList.get(j))).getMibAccess());
            mibGetResponseList.listadd(mibgetresponse);
        }

        sendResponse(mibGetResponseList, ois, oos);
    }
}
