/*
 * Created on 2003/07/25
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.alarm.trap.SenderAlarmTrap;
import netjfwatcher.engine.mail.MailSendInfoList;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.preferance.UnregistrationNodePreference;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.xmlsocket.XMLSocketConnectPushQueue;
import netjfwatcher.engine.socket.info.ResourceInfo;

/**
 * A[̈ȉ̏sNXłB
 * 
 * Ef[^x[XɃA[i[ EA[MailMXgւ̒ǉ EXML SocketʒmL[ւPush
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AlarmPut {
	/** A[Ďm[hłȂAAvP[VG[̏ꍇ̃m[h̑ */
	public static final String APL_ERROR_MESSAGE = "Application";
	/** A[Ďm[hłȂAHoney portXL̏ꍇ̃m[h̑ */
	public static final String HONEY_PORT_SCAN_NODE_MESSAGE = "Port Scan";
	
	/* MO */
	private static Logger logger = null;

	/* m[hoł̃A[tO */
	private boolean isNodeDiscovery = false;

	/*
	 * m[hĎe[uwp[^Ƀqbg m[hĎ擾NXCX^X
	 */
	private final SearchNoderegisterInfo nodeSearchInstance = new SearchNoderegisterInfo();

	/* A[tH[}bg */
	private final DateFormat dateformat = DateFormat.getDateTimeInstance();

	/*
	 * RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
	 * 
	 */
	private AlarmPut() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AlarmPut getInstance() {
		return SingletonAlarmPut.ALARMPUT;
	}

	/**
	 * A[e[uɃA[}܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param alarminfo
	 *            A[
	 * @param message
	 *            A[bZ[W
	 * @return A[e[ui[
	 */
	public synchronized boolean putAlarm(String ipaddress,
			AlarmCodeInformation alarminfo, String message) {
		if (!DatabaseControl.getInstance().isDatabaseStart()) {
			logger.warning("Abort put Alarm for Not running Database.");

			return false;
		}

		if (isNodeDiscovery) {
			return false;
		}

		String nodename;
		String group;

		if (!ipaddress.equals(APL_ERROR_MESSAGE) && !ipaddress.equals(HONEY_PORT_SCAN_NODE_MESSAGE) ) {
			// IP Address ɊYm[h
			ArrayList alarmList = nodeSearchInstance.searchInfo(
					DBTableAlarm.IPADDRESS, ipaddress);

			if ((alarmList != null) && (alarmList.size() != 0)) {
				nodename = ((NodeWatchInfo) alarmList.get(0)).getNodename();
				group = ((NodeWatchInfo) alarmList.get(0)).getGroup();
			} else {
				nodename = "unknown";
				group = "unknown";

				ResourceInfo resourceInfo = SystemResourceConfig.getInstance()
						.getResourceFileParse().getResourceInfo();
				if (resourceInfo.getUnregistrationNodeAlarm().equals(
						UnregistrationNodePreference.IGNORE)) {
						logger.info("Ignore Alarm Unregistration Node Alarm IP="
								+ ipaddress + " " + message);
						return false;					
				}
			}
		} else {
			nodename = ipaddress;
			group = "unknown";
		}

		DBTableAlarm alarmTable = DBTableAlarm.getInstance();

		try {
			// f[^x[X̃A[e[uɊi[
			alarmTable.putAlarm(ipaddress, nodename, group, alarminfo, message);
		} catch (DatabaseConnectionException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} catch (SQLException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} finally {
			alarmTable = null;
		}

		alarminfo.setIpaddress(ipaddress);
		alarminfo.setNodename(nodename);
		alarminfo.setGroup(group);
		AlarmMessageQueue.getInstance().pushAlarmData(alarminfo);

		/* A[MailMListɊi[ */
		MailSendInfoList.getInstance().setMailList(ipaddress, message,
				alarminfo.getLevel(), alarminfo.getCode());

		/* TrapM`FbN */
		SenderAlarmTrap.getInstance().checkAlarmTrap(ipaddress, message,
				alarminfo.getLevel(), alarminfo.getCode());

		/* XML SocketʒmA[L[Ɋi[ */
		Date date = Calendar.getInstance().getTime();

		XMLSocketConnectPushQueue pushqueue = XMLSocketConnectPushQueue
				.getInstance();

		/* IP Address: Date: Message` */
		pushqueue.addEventToXMLSocketInfoList(ipaddress + ": "
				+ dateformat.format(date) + ": " + message);

		return true;
	}

	/**
	 * m[hoɂA[tOԂ܂B
	 * 
	 * @return isNodeDiscovery m[hoɂA[tO
	 */
	public boolean isNodeDiscovery() {
		return isNodeDiscovery;
	}

	/**
	 * m[hoɂA[tOZbg܂B
	 * 
	 * @param isNodeDiscovery
	 *            m[hoɂA[tO
	 */
	public void setNodeDiscovery(boolean isNodeDiscovery) {
		this.isNodeDiscovery = isNodeDiscovery;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonAlarmPut {
		static final AlarmPut ALARMPUT = new AlarmPut();
	}
}
