/*
 * Created on 2004/04/29
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.SystemMib;


/**
 * VXeMIBi[e[u𑀍삷郁\bhNXłB
 * VXeMIBƂĈȉ̏Ǘ܂B
 * EsysDescr
 * EsysUpTime
 * EsysContact
 * EsysName
 * EsysLocation
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTableSystemMIB extends DBTableBase {
    /** m[hSystem MIBe[u Prefix */
    public final static String SNMP_SYS_TABLE_NAME = "_snmp";

    /** m[hIPAhX J */
    public static final String IPADDRESS = "ipaddress";

    /** m[h J */
    public static final String HOSTNAME = "hostname";

    /** Community J */
    public static final String COMMUNITY = "community";

    /** sysDescr J */
    public static final String SYS_DESC = "sysDescr";

    /** sysObjectID J */
    public static final String SYS_OBJECT_ID = "sysObjectID";

    /** sysUpTime J */
    public static final String SYS_UPTIME = "sysUpTime";

    /** sysContact J */
    public static final String SYS_CONTACT = "sysContact";

    /** sysName J */
    public static final String SYS_NAME = "sysName";

    /** sysLocation J */
    public static final String SYS_LOCATION = "sysLocation";

    /** ̎ J */
    public static final String SYS_CURDATE = "curdate";

    /* p[^ƂēnVXeMIBz̐ */
    private static final int SYSTEM_ARRAY_NO = 6;

    /* p[^ƂēnVXeMIBz̊ef[^ʒu */
    private static final int SYSDESC_POS = 0;
    private static final int SYSOBJECT_ID_POS = 1;
    private static final int SYSUPTIME_POS = 2;
    private static final int SYSCONTACT_POS = 3;
    private static final int SYSNAME_POS = 4;
    private static final int SYSLOCATION_POS = 5;

    /**
     * VXeMIBe[uJ
     */
    public static final String SNMP_SYSTEM_TABLE_ITEM =
        " (" + IPADDRESS + " VARCHAR(15), " + HOSTNAME + " VARCHAR(255), "
        + COMMUNITY + " VARCHAR(255), " + SYS_DESC + " VARCHAR(255), "
        + SYS_OBJECT_ID + " VARCHAR(255), " + SYS_UPTIME + " VARCHAR(255), "
        + SYS_CONTACT + " VARCHAR(255), " + SYS_NAME + " VARCHAR(255), "
        + SYS_LOCATION + " VARCHAR(255), " + SYS_CURDATE + " TIMESTAMP )";

    /* MO */
    private static Logger logger = null;

    /* VXeMIB̎tH[}bg */
    private final DateFormat dateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * System MIBi[e[u𐧌䂷CX^X𐶐܂B
     *
     */
    private DBTableSystemMIB() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * System MIBi[e[u𐧌䂷CX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static DBTableSystemMIB getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * SNMP System MIB e[u𐶐܂B
     *
     * @param targetIpAddress Agent IPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable(final String targetIpAddress)
        throws DatabaseConnectionException, SQLException {
        String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, ipaddress + SNMP_SYS_TABLE_NAME);

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                "CREATE TABLE " + ipaddress + SNMP_SYS_TABLE_NAME
                + SNMP_SYSTEM_TABLE_ITEM);

            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(
                targetIpAddress, ipaddress + SNMP_SYS_TABLE_NAME,
                DBTableManagement.LIMIT_NO);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * SNMP System MIB e[u폜܂B
     *
     * @param targetIpAddress Agent IPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable(final String targetIpAddress)
        throws DatabaseConnectionException, SQLException {
        String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, ipaddress + SNMP_SYS_TABLE_NAME);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * wIPAhX̃VXeMIBԂ܂B
     *
     * @param ipaddress Agent IPAhX
     * @return systemMibInfo VXeMIB
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized SystemMib findSystemMIBTable(final String ipaddress)
        throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        SystemMib systemMibInfo = null;

        String convIPaddress = DBTableBase.IP + ipaddress.replace('.', '_');
        convIPaddress = convIPaddress.replace('-', '_');

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + convIPaddress + SNMP_SYS_TABLE_NAME
                + " order by " + SYS_CURDATE + " desc";

            // select̎s
            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            systemMibInfo = new SystemMib();

            while (rs.next()) {
                systemMibInfo.setSysContact(
                    rs.getObject(SYS_CONTACT).toString());
                systemMibInfo.setSysDescr(rs.getObject(SYS_DESC).toString());
                systemMibInfo.setSysObjectID(
                    rs.getObject(SYS_OBJECT_ID).toString());
                systemMibInfo.setSysLocation(
                    rs.getObject(SYS_LOCATION).toString());
                systemMibInfo.setSysName(rs.getObject(SYS_NAME).toString());
                systemMibInfo.setSysUpTime(rs.getObject(SYS_UPTIME).toString());

                break;
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return systemMibInfo;
    }

    /**
     * VXeMIBf[^x[XɊi[܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @param community R~jeB
     * @param value VXeMIBi[z
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void putSystemMIBTable(
        String tragetIpAddress, String community, String[] value)
        throws DatabaseConnectionException, SQLException {
        if (value.length != SYSTEM_ARRAY_NO) {
            logger.warning("Illegal System MIB count = " + value.length);

            return;
        }

        String ipaddressTableName =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');

        String snmptablename = ipaddressTableName + SNMP_SYS_TABLE_NAME;

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            SystemResourceFileParse resourceset =
                (SystemResourceConfig.getInstance()).getResourceFileParse();
            String databaseKind =
                resourceset.getResourceInfo().getDatabaseName();

            String sysDescr;

            /* f[^x[XHSQLDB
             *
             * HSQLDB̏ꍇ́A'iVONH[e[Vjgp
             * łȂ̂ŃXy[Xɕϊ
             * HSQLDBȊOł́A'iVONH[e[Vj"(_u
             * NH[e[V)ɕϊDBɊi[
             */
            if (
                databaseKind.equals(AbstractDataAccessObject.HSQLDB)
                    || databaseKind.equals(AbstractDataAccessObject.POSTGRESQL)
                    || databaseKind.equals(AbstractDataAccessObject.DERBY)
                    || databaseKind.equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                /*
                 * SysDesc'(VONH[e[V)܂܂ꍇA
                 * HSQLDBł̓Xy[XϊDBɊi[)
                 */
                sysDescr = "'" + value[SYSDESC_POS].replaceAll("'", " ") + "',";
            } else {
                /*
                 * SysDesc'(VONH[e[V)܂܂ꍇA
                 * HSQLDBȊOł͗["(_uNH[e[V)Ƃ
                 * DBɊi[)
                 */
                sysDescr = "\"" + value[SYSDESC_POS] + "\",";
            }

            Date date = Calendar.getInstance().getTime();
            String sysObjectID = value[SYSOBJECT_ID_POS];
            String sysContact = value[SYSCONTACT_POS];
            String sysName = value[SYSNAME_POS];
            String sysLocation = value[SYSLOCATION_POS];
            databaseAccess.executeUpdate(
                "insert into " + snmptablename + "( " + IPADDRESS + ", "
                + HOSTNAME + ", " + COMMUNITY + ", " + SYS_DESC + ", "
                + SYS_OBJECT_ID + ", " + SYS_UPTIME + ", " + SYS_CONTACT + ", "
                + SYS_NAME + ", " + SYS_LOCATION + ", " + SYS_CURDATE + " )"
                + " VALUES( " + "'" + tragetIpAddress + "'," + "'" + "hostname"
                + "'," + "'" + community + "'," + sysDescr + "'" + sysObjectID
                + "'," + "'" + value[SYSUPTIME_POS] + "'," // sysUpTime
                + "'" + sysContact + "'," + "'" + sysName + "'," + "'"
                + sysLocation + "'," // sysLocation
                + "'" + dateformat.format(date) + "'" + ")");
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * VXeMIBi[e[uXV܂B
     * XVɂsysUpTimeȊOO̒lƈقȂĂꍇɂ́A
     * A[ʒms܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @param community R~jeB
     * @param value VXeMIBi[z
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void updateSystemMIBTable(
        final String tragetIpAddress, final String community,
        final String[] value) throws DatabaseConnectionException, SQLException {
        if (value.length != SYSTEM_ARRAY_NO) {
            logger.warning("Illegal System MIB count = " + value.length);

            return;
        }

        String ipaddressTableName =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');

        String snmptablename = ipaddressTableName + SNMP_SYS_TABLE_NAME;

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            SystemResourceFileParse resourceset =
                (SystemResourceConfig.getInstance()).getResourceFileParse();
            String databaseKind =
                resourceset.getResourceInfo().getDatabaseName();

            SystemMib systemMibInfo = this.findSystemMIBTable(tragetIpAddress);

            String sysDescr;
            String sysDescrOld = "";
            String sysDescrAlarmMessage;

            if (
                databaseKind.equals(AbstractDataAccessObject.HSQLDB)
                    || databaseKind.equals(AbstractDataAccessObject.POSTGRESQL)
                    || databaseKind.equals(AbstractDataAccessObject.DERBY)
                    || databaseKind.equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                /*
                 * SysDesc'(VONH[e[V)܂܂ꍇA
                 * HSQLDBł̓Xy[XϊDBɊi[)
                 */
                sysDescr = "'" + value[SYSDESC_POS].replaceAll("'", " ") + "'";

                if (systemMibInfo != null) {
                    sysDescrOld =
                        "'" + systemMibInfo.getSysDescr().replaceAll("'", " ")
                        + "'";
                }

                sysDescrAlarmMessage =
                    "(sysDescr=" + sysDescrOld + " --> " + sysDescr + ")";
            } else {
                /*
                 * SysDesc'(VONH[e[V)܂܂ꍇA
                 * HSQLDBȊOł͗["(_uNH[e[V)Ƃ
                 * DBɊi[)
                 */
                sysDescr = "\"" + value[SYSDESC_POS] + "\"";

                if (systemMibInfo != null) {
                    sysDescrOld = "\"" + systemMibInfo.getSysDescr() + "\"";
                    sysDescrAlarmMessage =
                        "(sysDescr=" + systemMibInfo.getSysDescr() + " --> "
                        + value[SYSDESC_POS] + ")";
                } else {
                    sysDescrAlarmMessage =
                        "(sysDescr=?" + " --> " + value[SYSDESC_POS] + ")";
                }
            }

            String sysObjectID = value[SYSOBJECT_ID_POS];
            String sysContact = value[SYSCONTACT_POS];
            String sysName = value[SYSNAME_POS];
            String sysLocation = value[SYSLOCATION_POS];
            Date date = Calendar.getInstance().getTime();

            /* OSystem MIB񂪂邩`FbN */
            if (systemMibInfo != null) {
                if (!sysDescrOld.equals(sysDescr)) {
                    /* sysDesc̕ωo */
                    logger.warning(
                        "Detect change of sysDesc. " + sysDescrAlarmMessage);

                    String message = sysDescrAlarmMessage;
                    setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysObjectID().equals(sysObjectID)) {
                    /* sysObjectID̕ωo */
                    logger.warning(
                        "Detect change of sysObjectID. Old sysObjectID="
                        + systemMibInfo.getSysObjectID() + " New sysObjectID="
                        + sysObjectID);

                    String message =
                        "(sysObjectID : " + systemMibInfo.getSysObjectID()
                        + "-->" + sysObjectID + ")";
                    setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysName().equals(sysName)) {
                    /* sysName̕ωo */
                    logger.warning(
                        "Detect change of sysName. Old sysName="
                        + systemMibInfo.getSysName() + " New sysName="
                        + sysName);

                    String message =
                        "(sysName : " + systemMibInfo.getSysName() + "-->"
                        + sysName + ")";
                    setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysLocation().equals(sysLocation)) {
                    /* sysLocation̕ωo */
                    logger.warning(
                        "Detect change of sysLocation. Old sysLocation="
                        + systemMibInfo.getSysLocation() + " New sysLocation="
                        + sysLocation);

                    String message =
                        "(sysLocation : " + systemMibInfo.getSysLocation()
                        + "-->" + sysLocation + ")";
                    setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysContact().equals(sysContact)) {
                    /* sysContact̕ωo */
                    logger.warning(
                        "Detect change of sysContact. Old sysContact="
                        + systemMibInfo.getSysContact() + " New sysContact="
                        + sysContact);

                    String message =
                        "(sysContact : " + systemMibInfo.getSysContact()
                        + "-->" + sysContact + ")";
                    setAlaram(tragetIpAddress, message, value, systemMibInfo);
                }

                // f[^x[Xe[uXV
                databaseAccess.executeUpdate(
                    "UPDATE " + snmptablename + " set " + IPADDRESS + "=" + "'"
                    + tragetIpAddress + "', " + HOSTNAME + "=" + "'"
                    + "hostname" + "', " + COMMUNITY + "=" + "'" + community
                    + "', " + SYS_DESC + "=" + sysDescr + "," + SYS_OBJECT_ID
                    + "=" + "'" + value[SYSOBJECT_ID_POS] + "', " + SYS_UPTIME
                    + "=" + "'" + value[SYSUPTIME_POS] + "', " + SYS_CONTACT
                    + "=" + "'" + sysContact + "', " + SYS_NAME + "=" + "'"
                    + sysName + "', " + SYS_LOCATION + "=" + "'" + sysLocation
                    + "', " + SYS_CURDATE + "=" + "'" + dateformat.format(date)
                    + "'");

                // databaseAccess.executeUpdate(AbstractDataAccessObject.COMMIT);
            } else {
                /*
                 * e[uɃf[^Ȃ̂Ńf[^x[Xe[uɃf[^Zbg
                 */
                databaseAccess.executeUpdate(
                    "INSERT " + snmptablename + " set " + IPADDRESS + "=" + "'"
                    + tragetIpAddress + "', " + HOSTNAME + "=" + "'"
                    + "hostname" + "', " + COMMUNITY + "=" + "'" + community
                    + "', " + SYS_DESC + "=" + sysDescr + SYS_UPTIME + "="
                    + "'" + value[SYSUPTIME_POS] + "', " + SYS_CONTACT + "="
                    + "'" + sysContact + "', " + SYS_NAME + "=" + "'" + sysName
                    + "', " + SYS_LOCATION + "=" + "'" + sysLocation + "', "
                    + SYS_CURDATE + "=" + "'" + dateformat.format(date) + "'");

                // databaseAccess.executeUpdate(AbstractDataAccessObject.COMMIT);
            }
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /*
     * System MIB̕ωoꍇɌĂ΂A[Zbg܂B
     *
     * @param tragetIpAddress@m[hIPAhX
     * @param message A[bZ[W
     */
    private void setAlaram(
        String tragetIpAddress, String message, String[] value,
        SystemMib systemMibInfo) {
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        alarm.setCahngeNodeSystemInfo(tragetIpAddress, message);

        /*
         *  System MIB̕ωoꍇSystem MIB񃍃MO
         */
        /* String sysDescr = value[SYSDESC_POS];
        String sysObjectID = value[SYSOBJECT_ID_POS];
        String sysUpTime = value[SYSUPTIME_POS];
        String sysContact = value[SYSCONTACT_POS];
        String sysName = value[SYSNAME_POS];
        String sysLocation = value[SYSLOCATION_POS];
        logger.info("sysDescr : " + sysDescr);
        logger.info("sysObjectID : " + sysObjectID);
        logger.info("sysUpTime : " + sysUpTime);
        logger.info("sysContact : " + sysContact);
        logger.info("sysName : " + sysName);
        logger.info("sysLocation : " + sysLocation);

        logger.info("SysDescr old : " + systemMibInfo.getSysDescr());
        logger.info("SysObjectID old : " + systemMibInfo.getSysObjectID());
        logger.info("SysName old : " + systemMibInfo.getSysName());
        logger.info("SysLocation old : " + systemMibInfo.getSysLocation());
        logger.info("SysContact old : " + systemMibInfo.getSysContact());
        */
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableSystemMIB RESOURCE = new DBTableSystemMIB();
    }
}
