/*
 * Created on 2004/04/29
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.info.InterfaceMib;


/**
 * MIBC^tF[Xe[u𑀍삷郁\bh܂B
 * m[h̃C^tF[X̕ωɂĂ`FbN܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTableInterfaceMIB extends DBTableBase {
    /** C^tF[Xe[uɕt镶 exp. ip_192_168_0_1_if */
    public static final String SNMP_IF_TABLE_NAME = "_if";

    /** ifIndex Description */
    public static final String IF_INDEX = "ifIndex";

    /** ifDesc */
    public static final String IF_DESC = "ifDesc";

    /** ifType */
    public static final String IF_TYPE = "ifType";

    /** ifMtu */
    public static final String IF_MTU = "ifMtu";

    /** ifSpeed */
    public static final String IF_SPEED = "ifSpeed";

    /** ifPhysAddress */
    public static final String IF_PHYSADDRESS = "ifPhysAddress";

    /** ifStatus */
    public static final String IF_STATUS = "ifStatus";

    /** ifAdminStatus */
    public static final String IF_ADMINSTATUS = "ifAdminStatus";

    /** ifOperStatus */
    public static final String IF_OPERSTATUS = "ifOperStatus";

    /**  */
    public static final String IF_CURDATE = "curdate";

    /* C^tF[XMIBi[e[ũJʒu */
    private static final int COLUMN_IFINDEX_NO = 1;
    private static final int COLUMN_IFDESC_NO = 2;
    private static final int COLUMN_IFTYPE_NO = 3;
    private static final int COLUMN_IFMTU_NO = 4;
    private static final int COLUMN_IFSPEED_NO = 5;
    private static final int COLUMN_IFPHYSADDRESS_NO = 6;
    private static final int COLUMN_IFADMINSTATUS_NO = 7;
    private static final int COLUMN_IFOPERSTATUS_NO = 8;

    /* MO */
    private static Logger logger = null;

    /**
     * ifOperStatusiC^tF[X̉^pԁjyifAdminStatus
     * iC^tF[X̊Ǘ̏ԁjɂUpԃR[h
     */
    public static final String UP_CODE = "1";

    /**
     * ifOperStatusiC^tF[X̉^pԁjyifAdminStatus
     * iC^tF[X̊Ǘ̏ԁjɂDownԃR[h
     */
    public static final String DOWN_CODE = "2";

    /**
     * ifOperStatusiC^tF[X̉^pԁjyifAdminStatus
     * iC^tF[X̊Ǘ̏ԁjɂTestingԃR[h
     */
    public static final String TESTING_CODE = "3";

    /** C^tF[X̉^pԂɂUpԂDescription */
    public static final String UP_STATUS = "Up";

    /** C^tF[X̉^pԂɂDownԂDescription  */
    public static final String DOWN_STATUS = "Down";

    /** C^tF[X̉^pԂɂTestingԂDescription  */
    public static final String TESTING_STATUS = "Testing";

    /*
     * C^tF[XɃC^tF[XMIBe[uɃJǉ邽߂
     * SQL
     */
    private static final String SNMP_INTERFACE_TABLE_ITEM =
        " (" + IF_INDEX + " " + AbstractDataAccessObject.BIGINT + " , "
        + IF_DESC + " VARCHAR(255), " + IF_TYPE + "  VARCHAR(10)," + IF_MTU
        + " VARCHAR(10)," + IF_SPEED + " VARCHAR(20)," + IF_PHYSADDRESS
        + " VARCHAR(40)," + IF_ADMINSTATUS + " VARCHAR(10)," + IF_OPERSTATUS
        + " VARCHAR(10) ," + IF_CURDATE + " " + AbstractDataAccessObject.TIMESTAMP + " )";

    // ifType擾CX^X
    private final IfTypeMibDisplay ifTypeMibDisplay = new IfTypeMibDisplay();

    /*  */
    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * C^tF[XMIBe[u𑀍삷VOgNX
     * CX^X𐶐܂B
     *
     */
    private DBTableInterfaceMIB() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP C^tF[XMIB e[u𐶐܂B
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable(final String targetIpAddress)
        throws DatabaseConnectionException, SQLException {
        /*  */
        String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');

        /*  */
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, ipaddress + SNMP_IF_TABLE_NAME);

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                "CREATE TABLE " + ipaddress + SNMP_IF_TABLE_NAME
                + SNMP_INTERFACE_TABLE_ITEM);

            /*  */
            DBTableManagement tableManagement = new DBTableManagement();

            /*  */
            tableManagement.put(
                targetIpAddress, ipaddress + SNMP_IF_TABLE_NAME,
                DBTableManagement.LIMIT_NO);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * SNMP C^tF[X MIB e[u폜
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable(final String targetIpAddress)
        throws DatabaseConnectionException, SQLException {
        // IPAhXe[uɕϊ
        String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, ipaddress + SNMP_IF_TABLE_NAME);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * wm[hIP AddressInterface MIB񃊃XgԂ܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @param  isConvIfDesc ifR[hifʕɕϊ邩ۂ
     * tO
     * @return nodeIfList Interface MIB񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findSNMPInterfaces(
        final String tragetIpAddress, final boolean isConvIfDesc)
        throws SQLException, DatabaseConnectionException {
        String convipaddress =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        convipaddress = convipaddress.replace('-', '_');

        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList nodeSNMPInterfacesList = new ArrayList();

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + convipaddress + SNMP_IF_TABLE_NAME
                + " order by " + IF_INDEX + " asc";

            // SQLXe[ggIuWFNg̍쐬
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
                InterfaceMib nodeInterfaceMib = new InterfaceMib();
                nodeInterfaceMib.setIfIndex(rs.getObject(IF_INDEX).toString());
                nodeInterfaceMib.setIfDesc(rs.getObject(IF_DESC).toString());
                nodeInterfaceMib.setIfMtu(rs.getObject(IF_MTU).toString());
                nodeInterfaceMib.setIfSpeed(rs.getObject(IF_SPEED).toString());
                nodeInterfaceMib.setIfPhysAddress(
                    rs.getObject(IF_PHYSADDRESS).toString());

                /*
                 * C^tF[XԂZbg
                 */
                nodeInterfaceMib.setIfAdminStatus(
                    rs.getObject(IF_ADMINSTATUS).toString());
                nodeInterfaceMib.setIfOperStatus(
                    rs.getObject(IF_OPERSTATUS).toString());

                String ifStatus =
                    setIfStatus(
                        rs.getObject(IF_OPERSTATUS).toString(),
                        rs.getObject(IF_ADMINSTATUS).toString());
                nodeInterfaceMib.setIfStatus(ifStatus);

                /*
                 * ifType
                 * (ifR[hifʕɕϊ邩ۂ)
                 */
                if (isConvIfDesc) {
                    /* ifR[hifʕ擾ifTypeƂ */
                    nodeInterfaceMib.setIfType(
                        ifTypeMibDisplay.getIfTypeString(
                            rs.getObject(IF_TYPE).toString()));
                } else {
                    /* ifR[ĥ܂iftypeƂ */
                    nodeInterfaceMib.setIfType(
                        rs.getObject(IF_TYPE).toString());
                }

                nodeSNMPInterfacesList.add(nodeInterfaceMib);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return nodeSNMPInterfacesList;
    }

    /**
     * C^tF[XMIBCfbNXɃf[^x[XɊi[܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesList C^tF[XMIBi[Xgzň
     * ziXgjOIDɑΉAXgɂ̓CfbNX̒li[
     * Ă
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾
     * oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void putSNMPInterfaces(
        final String tragetIpAddress, final ArrayList[] interfacesList)
        throws DatabaseConnectionException, SQLException {
        String ipaddressTableName =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');

        Date date = Calendar.getInstance().getTime();

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            /*
            "1.3.6.1.2.1.2.1",                // ifNumber
            "1.3.6.1.2.1.2.2.1.1",        // ifIndex
            "1.3.6.1.2.1.2.2.1.2",        // ifDescr
            "1.3.6.1.2.1.2.2.1.3",        // ifType
            "1.3.6.1.2.1.2.2.1.4",        // ifMtu
            "1.3.6.1.2.1.2.2.1.5",        // ifSpeed
            "1.3.6.1.2.1.2.2.1.6",        // ifPhysAddress
            "1.3.6.1.2.1.2.2.1.7",        // ifAdminStatus
            "1.3.6.1.2.1.2.2.1.8"        // ifOperStatus
            */

            // CfbNXɃf[^x[XɊi[
            for (int i = 0; i < interfacesList[COLUMN_IFINDEX_NO].size();
                    i++) {
                String ifDesc =
                    ((MibValue) (interfacesList[COLUMN_IFDESC_NO].get(i)))
                    .getMibValue();

                if (
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                 .equals(
                            AbstractDataAccessObject.DERBY)
                        || DatabaseAccessControlKind.getInstance()
                                                        .getDatabaseName()
                                                        .equals(
                            AbstractDataAccessObject.EMBEDDED_DERBY)) {
                    databaseAccess.executeUpdate(
                        "insert into " + ipaddressTableName
                        + SNMP_IF_TABLE_NAME + "( " + IF_INDEX + ", " + IF_DESC
                        + ", " + IF_TYPE + ", " + IF_MTU + ", " + IF_SPEED
                        + ", " + IF_PHYSADDRESS + ", " + IF_ADMINSTATUS + ", "
                        + IF_OPERSTATUS + ", " + IF_CURDATE + " )"
                        + " VALUES( "
                        + ((MibValue) (interfacesList[COLUMN_IFINDEX_NO].get(i)))
                        .getMibValue() + "," + "'" + ifDesc + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFTYPE_NO].get(i)))
                        .getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFMTU_NO].get(i)))
                        .getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFSPEED_NO].get(i)))
                        .getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFPHYSADDRESS_NO]
                        .get(i))).getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFADMINSTATUS_NO]
                        .get(i))).getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFOPERSTATUS_NO]
                        .get(i))).getMibValue() + "'," + "'"
                        + simpleDateformat.format(date) + "'" + ")");
                } else {
                    databaseAccess.executeUpdate(
                        "insert into " + ipaddressTableName
                        + SNMP_IF_TABLE_NAME + "( " + IF_INDEX + ", " + IF_DESC
                        + ", " + IF_TYPE + ", " + IF_MTU + ", " + IF_SPEED
                        + ", " + IF_PHYSADDRESS + ", " + IF_ADMINSTATUS + ", "
                        + IF_OPERSTATUS + ", " + IF_CURDATE + " )"
                        + " VALUES( " + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFINDEX_NO].get(i)))
                        .getMibValue() + "'," + "'" + ifDesc + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFTYPE_NO].get(i)))
                        .getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFMTU_NO].get(i)))
                        .getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFSPEED_NO].get(i)))
                        .getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFPHYSADDRESS_NO]
                        .get(i))).getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFADMINSTATUS_NO]
                        .get(i))).getMibValue() + "'," + "'"
                        + ((MibValue) (interfacesList[COLUMN_IFOPERSTATUS_NO]
                        .get(i))).getMibValue() + "'," + "'"
                        + simpleDateformat.format(date) + "'" + ")");
                }

                // databaseAccess.executeUpdate(AbstractDataAccessObject.COMMIT);
            }
        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress);
            throw ex;
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
            throw e;
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * C^tF[XMIBXV܂B
     * C^tF[X񂪕ωꍇɂ́AA[ʒm܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesArrayList Listz̈OIDɑΉAz񖈂
     * IndexɑΉC^tF[XMIB񂪓
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void updateSNMPInterfaces(
        final String tragetIpAddress, final ArrayList[] interfacesArrayList)
        throws DatabaseConnectionException, SQLException {
        /*
         * C^tF[XMIBωĎ
         */
        checkInterfaceMib(tragetIpAddress, interfacesArrayList);

        String ipaddressTablename =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTablename = ipaddressTablename.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            /*
            "1.3.6.1.2.1.2.1",                // ifNumber
            "1.3.6.1.2.1.2.2.1.1",        // ifIndex
            "1.3.6.1.2.1.2.2.1.2",        // ifDescr
            "1.3.6.1.2.1.2.2.1.3",        // ifType
            "1.3.6.1.2.1.2.2.1.4",        // ifMtu
            "1.3.6.1.2.1.2.2.1.5",        // ifSpeed
            "1.3.6.1.2.1.2.2.1.6",        // ifPhysAddress
            "1.3.6.1.2.1.2.2.1.7",        // ifAdminStatus
            "1.3.6.1.2.1.2.2.1.8"        // ifOperStatus
            */
            updateIntefaceTabel(
                databaseAccess, interfacesArrayList, ipaddressTablename);
        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress);
            ex.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
            e.printStackTrace();
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * C^tF[XMIB̕ωĎ܂B
     * C^tF[X񂪕ωꍇɂ́AA[ʒm܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @param interfacesArrayList C^tF[XMIBi[Xg
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void checkInterfaceMib(
        final String tragetIpAddress, final ArrayList[] interfacesArrayList)
        throws DatabaseConnectionException, SQLException {
        /*
         * f[^x[XɊi[ĂIndex̃C^tF[XMIB擾
         * ÃG[WFg̎擾Ƃ̕ω`FbN
         */
        ArrayList preOidList = this.findSNMPInterfaces(tragetIpAddress, false);

        /*
         * VIndexrăC^tF[XύXĎ
         */
        if (interfacesArrayList[COLUMN_IFINDEX_NO].size() != preOidList.size()) {
            /* Indexωꍇɂ̓A[ʒm */
            String message =
                "(" + preOidList.size() + "-->"
                + interfacesArrayList[COLUMN_IFINDEX_NO].size() + ")";
            setAlaram(
                tragetIpAddress, message, interfacesArrayList, preOidList);

            logger.info(
                "interfacesList[COLUMN_IFINDEX_NO].size() : "
                + interfacesArrayList[COLUMN_IFINDEX_NO].size());
            logger.info("preOidList.size() : " + preOidList.size());

            for (int i = 0; i < preOidList.size(); i++) {
                InterfaceMib interfaceMib = (InterfaceMib) preOidList.get(i);
                logger.info("IfIndex : " + interfaceMib.getIfIndex());
                logger.info("IfDesc : " + interfaceMib.getIfDesc());
                logger.info("IfMtu : " + interfaceMib.getIfMtu());
                logger.info("IfSpeed : " + interfaceMib.getIfSpeed());
                logger.info(
                    "IfPhysAddress : " + interfaceMib.getIfPhysAddress());
            }

            for (int i = 0; i < interfacesArrayList.length; i++) {
                ArrayList ifList = interfacesArrayList[i];

                for (int j = 0; j < ifList.size(); j++) {
                    logger.info(
                        "now i=" + i + " j=" + j + " value="
                        + (String) ifList.get(j));
                }
            }

            /*
             * C^tF[Xe[ȗSẴC^tF[Xf[^
             * 폜āAēxC^tF[Xf[^e[uɑ}
             */
            this.deleteIfIndex(tragetIpAddress, preOidList);
            this.putSNMPInterfaces(tragetIpAddress, interfacesArrayList);

            return;
        }

        for (
            int oidCount = 0;
                oidCount < interfacesArrayList[COLUMN_IFINDEX_NO].size();
                oidCount++) {
            String ifIndex =
                ((MibValue) (interfacesArrayList[COLUMN_IFINDEX_NO].get(
                    oidCount))).getMibValue();

            String ifType =
                ((MibValue) (interfacesArrayList[COLUMN_IFTYPE_NO].get(
                    oidCount))).getMibValue();

            String ifDesc =
                ((MibValue) (interfacesArrayList[COLUMN_IFDESC_NO].get(
                    oidCount))).getMibValue();

            String ifTypeName = ifTypeMibDisplay.getIfTypeString(ifType);

            String interfaceDescription =
                "(" + ifTypeName + " : " + ifDesc + ")";

            /* VifIndexv܂Ō */
            boolean isFoundIfIndex = false;
            InterfaceMib interfaceMibInfo = null;

            for (int j = 0; j < preOidList.size(); j++) {
                interfaceMibInfo = (InterfaceMib) preOidList.get(j);

                String ifIndexOld = interfaceMibInfo.getIfIndex();

                if (ifIndexOld.equals(ifIndex)) {
                    isFoundIfIndex = true;

                    break;
                }
            }

            /* ifIndexȂ(VifIndexvȂ)ꍇ̓C^tF[XύX */
            if (!isFoundIfIndex) {
                logger.warning(
                    "Not Found ifIndex " + interfaceMibInfo.getIfIndex());
                logger.warning(
                    "(Detect new ifIndex=" + ifIndex + " ifDesc=" + ifDesc
                    + "(" + ifTypeName + "))");

                String message =
                    "(Detect new ifIndex=" + ifIndex + " ifDesc=" + ifDesc
                    + "(" + ifTypeName + "))";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);

                /* C^tF[Xe[ȗSẴC^tF[X
                 * f[^폜āAēxC^tF[Xf[^
                 * e[uɑ}
                 */
                this.deleteIfIndex(tragetIpAddress, preOidList);
                this.putSNMPInterfaces(tragetIpAddress, interfacesArrayList);

                return;
            }

            String ifDescOld = interfaceMibInfo.getIfDesc();

            if (!ifDescOld.equals(ifDesc)) {
                if (!checkInterfaceMIBDataString(ifDesc, ifDescOld)) {
                    logger.warning(
                        "Old ifDesc=" + ifDescOld + " New ifDesc=" + ifDesc);

                    String message =
                        "(ifIndex=" + ifIndex + interfaceDescription
                        + " ifDesc : " + ifDescOld + "-->" + ifDesc + ")";
                    setAlaram(
                        tragetIpAddress, message, interfacesArrayList,
                        preOidList);
                }
            }

            String ifTypeOld = interfaceMibInfo.getIfType();

            if (!ifTypeOld.equals(ifType)) {
                logger.warning(
                    "Old ifType=" + ifTypeOld + " New ifType=" + ifType);

                String message =
                    "(ifIndex=" + ifIndex + interfaceDescription + " ifType : "
                    + ifTypeOld + "-->" + ifType + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }

            String ifMtuOld = interfaceMibInfo.getIfMtu();
            String ifMtu =
                ((MibValue) (interfacesArrayList[COLUMN_IFMTU_NO].get(oidCount)))
                .getMibValue();

            if (!ifMtuOld.equals(ifMtu)) {
                logger.warning("Old ifMtu=" + ifMtuOld + " New ifMtu=" + ifMtu);

                String message =
                    "(ifIndex=" + ifIndex + interfaceDescription + " ifMtu : "
                    + ifMtuOld + "-->" + ifMtu + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }

            String ifSpeedOld = interfaceMibInfo.getIfSpeed();
            String ifSpeed =
                ((MibValue) (interfacesArrayList[COLUMN_IFSPEED_NO].get(
                    oidCount))).getMibValue();

            if (!ifSpeedOld.equals(ifSpeed)) {
                logger.warning(
                    "Old ifSpeed=" + ifSpeedOld + " New ifSpeed=" + ifSpeed);

                String message =
                    "(ifIndex=" + ifIndex + interfaceDescription
                    + " ifSpeed : " + ifSpeedOld + "-->" + ifSpeed + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }

            String ifPhysAddressOld = interfaceMibInfo.getIfPhysAddress();
            String ifPhysAddress =
                ((MibValue) (interfacesArrayList[COLUMN_IFPHYSADDRESS_NO].get(
                    oidCount))).getMibValue();

            if (!ifPhysAddressOld.equals(ifPhysAddress)) {
                logger.info(
                    "Old ifPhysAddress=" + ifPhysAddressOld
                    + " New ifPhysAddress=" + ifPhysAddress);

                String message =
                    "(ifIndex=" + ifIndex + interfaceDescription
                    + " ifPhysAddress : " + ifPhysAddressOld + "-->"
                    + ifPhysAddress + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }

            /*
             * C^tF[XԕωĎ
             *
             */
            String ifAdminStatusOld = interfaceMibInfo.getIfAdminStatus();
            String ifAdminStatus =
                ((MibValue) (interfacesArrayList[COLUMN_IFADMINSTATUS_NO].get(
                    oidCount))).getMibValue();
            String ifOperStatusOld = interfaceMibInfo.getIfOperStatus();
            String ifOperStatus =
                ((MibValue) (interfacesArrayList[COLUMN_IFOPERSTATUS_NO].get(
                    oidCount))).getMibValue();

            if (
                !ifAdminStatusOld.equals(ifAdminStatus)
                    || !ifOperStatusOld.equals(ifOperStatus)) {
                String nowStatus = setIfStatus(ifOperStatus, ifAdminStatus);
                String preStatus =
                    setIfStatus(ifOperStatusOld, ifAdminStatusOld);
                logger.info(
                    "(ifIndex=" + ifIndex + interfaceDescription + " "
                    + preStatus + "-->" + nowStatus + " (ifAdminStatus : "
                    + ifAdminStatusOld + "-->" + ifAdminStatus
                    + " , ifOperStatus : " + ifOperStatusOld + "-->"
                    + ifOperStatus + "))");

                String message =
                    "(ifIndex=" + ifIndex + interfaceDescription + " "
                    + preStatus + "-->" + nowStatus + " (ifAdminStatus : "
                    + ifAdminStatusOld + "-->" + ifAdminStatus
                    + " , ifOperStatus : " + ifOperStatusOld + "-->"
                    + ifOperStatus + "))";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }
        }
    }

    /*
     * C^tF[XMIB̕ωoꍇɌĂ΂A[Zbg܂B
     *
     * @param tragetIpAddress@m[hIPAhX
     * @param message A[bZ[W
     */
    private void setAlaram(
        String tragetIpAddress, String message,
        final ArrayList[] interfacesArrayList, ArrayList preOidList) {
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        alarm.setCahngeInterfaceStatus(tragetIpAddress, message);

        /*
         * C^tF[XMIBω̍̎f[^O
         */
        /* for (
            int oidCount = 0;
                oidCount < interfacesArrayList[COLUMN_IFINDEX_NO].size();
                oidCount++) {
            String ifIndex =
                ((MibValue) (interfacesArrayList[COLUMN_IFINDEX_NO].get(
                    oidCount))).getMibValue();

            String ifType =
                ((MibValue) (interfacesArrayList[COLUMN_IFTYPE_NO].get(
                    oidCount))).getMibValue();

            String ifDesc =
                ((MibValue) (interfacesArrayList[COLUMN_IFDESC_NO].get(
                    oidCount))).getMibValue();

            String ifTypeName = ifTypeMibDisplay.getIfTypeString(ifType);

            String interfaceDescription =
                "(" + ifTypeName + " : " + ifDesc + ")";
            String ifMtu =
                ((MibValue) (interfacesArrayList[COLUMN_IFMTU_NO].get(oidCount)))
                .getMibValue();
            String ifSpeed =
                ((MibValue) (interfacesArrayList[COLUMN_IFSPEED_NO].get(
                    oidCount))).getMibValue();
            String ifPhysAddress =
                ((MibValue) (interfacesArrayList[COLUMN_IFPHYSADDRESS_NO].get(
                    oidCount))).getMibValue();

            String ifAdminStatus =
                ((MibValue) (interfacesArrayList[COLUMN_IFADMINSTATUS_NO].get(
                    oidCount))).getMibValue();

            String ifOperStatus =
                ((MibValue) (interfacesArrayList[COLUMN_IFOPERSTATUS_NO].get(
                    oidCount))).getMibValue();

            logger.info("ifIndex       " + oidCount + " : " + ifIndex);
            logger.info("ifType        " + oidCount + " : " + ifType);
            logger.info("ifDesc        " + oidCount + " : " + ifDesc);
            logger.info("ifTypeName    " + oidCount + " : " + ifTypeName);
            logger.info(
                "interfaceDescription  " + oidCount + " : "
                + interfaceDescription);
            logger.info("ifMtu         " + oidCount + " : " + ifMtu);
            logger.info("ifSpeed       " + oidCount + " : " + ifSpeed);
            logger.info("ifPhysAddress " + oidCount + " : " + ifPhysAddress);
            logger.info("ifAdminStatus " + oidCount + " : " + ifAdminStatus);
            logger.info("ifOperStatus  " + oidCount + " : " + ifOperStatus);
        }
        */
        /* InterfaceMib interfaceMibInfo = null;

        for (int j = 0; j < preOidList.size(); j++) {
            interfaceMibInfo = (InterfaceMib) preOidList.get(j);

            String ifIndexOld = interfaceMibInfo.getIfIndex();
            String ifDescOld = interfaceMibInfo.getIfDesc();
            String ifTypeOld = interfaceMibInfo.getIfType();
            String ifMtuOld = interfaceMibInfo.getIfMtu();
            String ifSpeedOld = interfaceMibInfo.getIfSpeed();
            String ifPhysAddressOld = interfaceMibInfo.getIfPhysAddress();
            String ifAdminStatusOld = interfaceMibInfo.getIfAdminStatus();
            String ifOperStatusOld = interfaceMibInfo.getIfOperStatus();

            logger.info("ifIndexOld       " + j + " : " + ifIndexOld);
            logger.info("ifDescOld        " + j + " : " + ifDescOld);
            logger.info("ifTypeOld        " + j + " : " + ifTypeOld);
            logger.info("ifIndexOld       " + j + " : " + ifIndexOld);
            logger.info("ifMtuOld         " + j + " : " + ifMtuOld);
            logger.info("ifSpeedOld       " + j + " : " + ifSpeedOld);
            logger.info("ifPhysAddressOld " + j + " : " + ifPhysAddressOld);
            logger.info("ifAdminStatusOld " + j + " : " + ifAdminStatusOld);
            logger.info("ifOperStatusOld  " + j + " : " + ifOperStatusOld);
        }
        */
    }

    /**
     * C^tF[XMIBe[uXV܂B
     *
     * @param databaseAccess f[^x[XANZXIuWFNg
     * @param interfacesArrayList C^tF[XMIBi[Xg
     * @param ipaddressTablename e[u
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void updateIntefaceTabel(
        DatabaseAccess databaseAccess, final ArrayList[] interfacesArrayList,
        String ipaddressTablename)
        throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();

        for (int i = 0; i < interfacesArrayList[1].size(); i++) {
            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.DERBY)
                    || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                    .equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                databaseAccess.executeUpdate(
                    "UPDATE " + ipaddressTablename + SNMP_IF_TABLE_NAME
                    + " set " + IF_INDEX + "= "
                    + ((MibValue) (interfacesArrayList[COLUMN_IFINDEX_NO].get(
                        i))).getMibValue() + ", " + IF_DESC + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFDESC_NO].get(i)))
                    .getMibValue() + "', " + IF_TYPE + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFTYPE_NO].get(i)))
                    .getMibValue() + "', " + IF_MTU + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFMTU_NO].get(i)))
                    .getMibValue() + "', " + IF_SPEED + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFSPEED_NO].get(
                        i))).getMibValue() + "', " + IF_PHYSADDRESS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFPHYSADDRESS_NO]
                    .get(i))).getMibValue() + "', " + IF_ADMINSTATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFADMINSTATUS_NO]
                    .get(i))).getMibValue() + "', " + IF_OPERSTATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFOPERSTATUS_NO]
                    .get(i))).getMibValue() + "', " + IF_CURDATE + "='"
                    + simpleDateformat.format(date) + "'" + " where "
                    + IF_INDEX + "= "
                    + ((MibValue) (interfacesArrayList[1].get(i))).getMibValue()
                    + " ");
            } else {
                databaseAccess.executeUpdate(
                    "UPDATE " + ipaddressTablename + SNMP_IF_TABLE_NAME
                    + " set " + IF_INDEX + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFINDEX_NO].get(
                        i))).getMibValue() + "', " + IF_DESC + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFDESC_NO].get(i)))
                    .getMibValue() + "', " + IF_TYPE + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFTYPE_NO].get(i)))
                    .getMibValue() + "', " + IF_MTU + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFMTU_NO].get(i)))
                    .getMibValue() + "', " + IF_SPEED + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFSPEED_NO].get(
                        i))).getMibValue() + "', " + IF_PHYSADDRESS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFPHYSADDRESS_NO]
                    .get(i))).getMibValue() + "', " + IF_ADMINSTATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFADMINSTATUS_NO]
                    .get(i))).getMibValue() + "', " + IF_OPERSTATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_IFOPERSTATUS_NO]
                    .get(i))).getMibValue() + "', " + IF_CURDATE + "='"
                    + simpleDateformat.format(date) + "'" + " where "
                    + IF_INDEX + "='"
                    + ((MibValue) (interfacesArrayList[1].get(i))).getMibValue()
                    + "';");
            }
        }
    }

    /**
     * C^tF[Xe[ȗSĂIndex폜܂B
     * ́AC^tF[X܂́AIndexԍωꍇŁA
     * e[uXVoȂ̂ňUAe[u폜čēxA
     * e[u邽߂ɌĂ΂܂B
     *
     *
     * @param tragetIpAddress m[hIPAhX
     * @param preOidList O̎悵OIDCX^XXg
     * @return
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void deleteIfIndex(
        final String tragetIpAddress, final ArrayList preOidList)
        throws DatabaseConnectionException, SQLException {
        String ipaddressTableName =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // DatabaseAccess databaseAccess = new DatabaseAccess();
            for (int i = 0; i < preOidList.size(); i++) {
                InterfaceMib nodeview = (InterfaceMib) preOidList.get(i);

                String ifIndex = nodeview.getIfIndex();

                String sql = "";

                //sql̍쐬
                sql = "DELETE from " + ipaddressTableName + SNMP_IF_TABLE_NAME
                    + " where " + IF_INDEX + "=" + "'" + ifIndex + "'";

                databaseAccess.executeUpdate(sql);
            }
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /*
     * f[^x[XւASCIIȊO̊i[s̏ꍇɊi[ꂽf[^
     * of[^̐擪ASCIÎݔrs܂B
     *
     * @param newDataString ̎f[^
     * @param oldDataString O̎f[^
     * @return i[sł܂ł̕riωĎj
     * true  : v
     * false : sv
     */
    private boolean checkInterfaceMIBDataString(
        final String newDataString, final String oldDataString) {
        SystemResourceFileParse resourceset =
            (SystemResourceConfig.getInstance()).getResourceFileParse();
        String databaseKind = resourceset.getResourceInfo().getDatabaseName();

        char checkCode = '?';

        if (databaseKind.equals(AbstractDataAccessObject.MYSQL)) {
            checkCode = '?';
        }

        boolean isMuch = false;

        /* i[sł܂ł̈ʒu擾 */
        int checkPos = oldDataString.indexOf(checkCode);

        if (checkPos > 0) {
            /* i[sł܂ł̕擾 */
            String checkIfDesc = oldDataString.substring(0, checkPos);

            /*
             * i[sł܂ł̕񂪁AV̎悵
             * MIBf[^Ɋ܂܂邩`FbN
             */
            int check2 = newDataString.indexOf(checkIfDesc);

            if (check2 >= 0) {
                /*
                 * i[sł܂ł̕񂪁AV̎悵
                 * MIBf[^Ɋ܂܂ꍇɂ͐Vf[^v
                 * Ɣf
                 */
                isMuch = true;
            }
        }

        return isMuch;
    }

    /**
     * ifOperStatusiC^tF[X̉^pԁjyifAdminStatus
     * iC^tF[X̊Ǘ̏ԁjC^tF[XԂ
     * Up/DownyTestingƂĕԂ܂B
     *
     * up:1
     * down:2
     * testing:3
     *
     * @param ifOperStatus C^tF[X̉^p
     * @param ifAdminStatus C^tF[X̊Ǘ̏
     * @return ifStatus C^tF[X
     */
    private synchronized String setIfStatus(
        String ifOperStatus, String ifAdminStatus) {
        String ifStatus;

        if (ifOperStatus.equals(UP_CODE)) {
            ifStatus = UP_STATUS;
        } else if (ifOperStatus.equals(DOWN_CODE)) {
            ifStatus = DOWN_STATUS;
        } else if (ifOperStatus.equals(TESTING_CODE)) {
            ifStatus = TESTING_STATUS;
        } else {
            ifStatus = "Unknown";
            logger.warning(
                "ifStatus=" + ifStatus + " (ifOperStatus=" + ifOperStatus
                + " ifAdminStatus=" + ifAdminStatus + ")");
        }

        return ifStatus;
    }

    /**
     * VOgNXCX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static DBTableInterfaceMIB getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableInterfaceMIB RESOURCE = new DBTableInterfaceMIB();
    }
}
