/*
 * Created on 2004/04/29
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.control;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.ApacheDerbyDatabaseInit;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.database.access.model.DBTableAlarmFilter;
import netjfwatcher.database.access.model.DBTableDatabaseWatcher;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNetworkCamera;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTableTaskSchedule;
import netjfwatcher.database.access.model.MySQLDatabaseInit;
import netjfwatcher.database.access.model.PostgreSQLDatabaseInit;



/**
 * f[^x[X𐶐RlNVPool𐶐ƂƂɁAȉ̃e[u𐶐܂B
 *
 * Em[ho^e[u
 * EA[e[u
 * Em[hMap-Linke[u
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConstructDatabase {
    /* MO */
    private static Logger logger = null;

    /**
     * f[^x[X̃RlNVPoolƃe[usCX^X𐶐܂B
     *
     */
    public ConstructDatabase() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * RlNVPool𐶐܂B
     *
     */
    public final void createPool() {
        /* f[^x[XRlNVPool */
        DatabaseConnectionPool.getInstance().createConnectionPool();

        /* f[^x[XANZXPool */
        DatabaseAccessPool.getInstance().setDatabaseAccessQueueList();
    }

    /**
     * f[^x[Xe[u𐶐܂B
     * ܂AMySQL̏ꍇ̓f[^x[X𐶐܂B
     *
     * Em[ho^e[u
     * EA[e[u
     * Em[hMap-Linke[u
     *
     */
    public final void createTable() {
        /* f[^x[X쐬 */

        // createDatabase();
        // e[u
        try {
            DBTableGarbageCollection garbageCollection =
                DBTableGarbageCollection.getInstance();
            garbageCollection.createTable();

            // m[hĎe[u
            DBTableNodeRegister noderegister =
                DBTableNodeRegister.getInstance();
            noderegister.createTable();

            // A[e[u
            DBTableAlarm alarmTable = DBTableAlarm.getInstance();
            alarmTable.createTable();

            // A[tB^[e[u
            DBTableAlarmFilter alarmFilterTable = new DBTableAlarmFilter();
            alarmFilterTable.createTable();
            alarmFilterTable.putAlarmFilter();

            // ^XNXPW[e[u
            DBTableTaskSchedule taskScheduleTable =
                DBTableTaskSchedule.getInstance();
            taskScheduleTable.createTable();

            // Mape[u
            DBTableMapLink mapLinkTable = new DBTableMapLink();
            mapLinkTable.createTable();

            // e[uǗe[u
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.createTable();
    		// f[^x[XĎe[u
    		DBTableDatabaseWatcher.getInstance().createTable();
    		// Network Camerae[u
    		DBTableNetworkCamera.getInstance().createTable();
        } catch (DatabaseConnectionException e) {
            e.printStackTrace();
            logger.severe(e.getMessage());
        } catch (SQLException e) {
            e.printStackTrace();
            logger.severe(e.getMessage());
        }
    }

    /**
     * f[^x[XwɃf[^x[XʖɃf[^x[X
     * ܂B
     *
     */
    public final void createDatabase() {
        try {
            // MySQLAPostgreSQLyApache Derby̏ꍇ̓f[^x[XɃf[^x[X𐶐
            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.MYSQL)) {
                // MySQLf[^x[X
                MySQLDatabaseInit mysqlInit = new MySQLDatabaseInit();
                mysqlInit.createDatabase();
            } else if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.POSTGRESQL)) {
                // PostgreSQLf[^x[X
                PostgreSQLDatabaseInit.getInstance().createDatabase();
            } else if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.DERBY)
                    || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                    .equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                // Apache Derbyf[^x[X
                ApacheDerbyDatabaseInit apacheDerby =
                    new ApacheDerbyDatabaseInit();
                apacheDerby.createDatabase();
            }

        } catch (SQLException e1) {
            logger.warning("SQLException " + e1.getMessage());

            /* database already exists̏ꍇ */

            // e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning("Exception " + e1.getMessage());
            e1.printStackTrace();
        }
    }
}
