/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.macaddress.gui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionInterfaceMib;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.InterfaceMib;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.macaddress.preference.MacAddressConfig;
import netjfwatcher.macaddress.preference.MacAddressInfo;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/**
 * SNMPĎm[h̃C^tF[XMAChX\Editor ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMacAddressEditorView extends AbstractEditorNodeView {

	/* MO */
	private static Logger logger;

	/* MAC OUI Length */
	private static final int OUI_LENGTH = 6;

	/* Interface MIBe[u JRatio */
	private static final float COLUMN_NO_RATIO = 0.04f;

	private static final float COLUMN_IP_RATIO = 0.1f;

	private static final float COLUMN_NODENAME_RATIO = 0.1f;

	private static final float COLUMN_IFINDEX_RATIO = 0.04f;

	private static final float COLUMN_IFDESC_RATIO = 0.1f;

	private static final float COLUMN_IFTYPE_RATIO = 0.1f;

	private static final float COLUMN_IFMTU_RATIO = 0.1f;

	private static final float COLUMN_IFSPEED_RATIO = 0.1f;

	private static final float COLUMN_IFPHYSADDRESS_RATIO = 0.3f;

	private static final float COLUMN_IFSTATUS_RATIO = 0.1f;

	private static final int NO_POS = 0;

	private static final int IP_ADDRESS_POS = 1;

	private static final int NODE_NAME_POS = 2;

	private static final int IFINDEX_POS = 3;

	private static final int IFDESC_POS = 4;

	private static final int IFTYPE_POS = 5;

	private static final int IFMTU_POS = 6;

	private static final int IFSPEED_POS = 7;

	private static final int IFPHYSADDRESS_POS = 8;

	private static final int IFSTATUS_POS = 9;

	private static final int COLUMN_NO = 10;

	/* XV{^ */
	private Button refreshButton;

	private Button socketClientButton;

	/* Interface MIB\ TableViewer */
	private TableViewer viewer;

	/* Text BackColor */
	private Color textBackColor;

	private long ifCount = 0;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public NodeMacAddressEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		/* Snmp System MIBTextBackground color */
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridLayout gridLayout = new GridLayout(2, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

		refreshButton = new Button(composite, SWT.NONE);
		refreshButton.setText("Refresh");
		refreshButton.setLayoutData(new GridData());

		socketClientButton = new Button(composite, SWT.NONE);
		socketClientButton.setText("Socket Client");
		socketClientButton.setLayoutData(new GridData());

		/* Interface MIB\e[uZbg */
		SnmpInterfaceMibTable statisticsTable = new SnmpInterfaceMibTable();
		table = statisticsTable.createTable(parent);

		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		/* Interface MIBe[u\ */
		setNodeInterfaceTable(false, false);

		/*
		 * XV{^Xi[
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);

				setNodeInterfaceTable(false, true);

				refreshButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		socketClientButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				socketClientButton.setEnabled(false);

				setNodeInterfaceTable(true, true);

				socketClientButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	private void setNodeInterfaceTable(boolean isSocket, boolean isShow) {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();
		ifCount = 0;

		ArrayList nodeList = getNodeList(isSocket, isShow);
		if (nodeList == null) {
			return;
		}
		for (int i = 0; i < nodeList.size(); i++) {
			NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);

			/*
			 * wm[hInterface MIB擾
			 */
			ArrayList interfaceMibList = getInterfaceMib(nodeInfo, isShow,
					isSocket);

			/* Interface MIBXgɂăe[u\ */
			setInterfaceMibTable(nodeInfo, interfaceMibList);
		}
	}

	private ArrayList getNodeList(boolean isSocket, boolean isShowErrorDialog) {
		ArrayList nodeList = null;

		if (!isSocket) {
			DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
					.getInstance();

			try {
				nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
			} catch (SQLException e1) {
				logger.warning(e1.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e1.getMessage());
				shell.dispose();

				return null;
			} catch (Exception e1) {
				logger.warning(e1.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e1.getMessage());
				shell.dispose();

				return null;
			}
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			try {
				ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
						engineAddress);
				nodeList = connectNodeInfo.getNodeInformationList(null, null);
			} catch (EngineConnectException e1) {
				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Node List import error", e1
							.getMessage()
							+ " Engine = " + engineAddress);
					logger.warning("Node List import error" + e1.getMessage());
					shell.dispose();
				}

				return null;
			} catch (IOException e1) {
				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Node List import error", e1
							.getMessage()
							+ " Engine = " + engineAddress);
					logger.warning("Node List import error" + e1.getMessage());
					shell.dispose();
				}

				return null;
			}
		}

		return nodeList;
	}

	/*
	 * w肳ꂽInterface MIB ListInterface MIBe[u \܂B
	 */
	private void setInterfaceMibTable(NodeInformation nodeInfo,
			ArrayList interfaceMibList) {
		if (interfaceMibList == null) {
			return;
		}

		/* InterfacePʂɃe[uRowɃZbg */
		InterfaceMib nodeInterfaceMib = null;

		for (int i = 0; i < interfaceMibList.size(); i++) {
			ifCount++;

			String[] interfaceTableCellArray = new String[COLUMN_NO];

			nodeInterfaceMib = (InterfaceMib) interfaceMibList.get(i);
			interfaceTableCellArray[NO_POS] = Long.toString(ifCount);
			interfaceTableCellArray[IP_ADDRESS_POS] = nodeInfo.getIpaddress();
			interfaceTableCellArray[NODE_NAME_POS] = nodeInfo.getNodename();

			interfaceTableCellArray[IFINDEX_POS] = nodeInterfaceMib
					.getIfIndex();
			interfaceTableCellArray[IFDESC_POS] = nodeInterfaceMib.getIfDesc();
			interfaceTableCellArray[IFTYPE_POS] = nodeInterfaceMib.getIfType();
			interfaceTableCellArray[IFMTU_POS] = nodeInterfaceMib.getIfMtu();
			interfaceTableCellArray[IFSPEED_POS] = nodeInterfaceMib
					.getIfSpeed();

			String vedorName = searchVedorID(nodeInterfaceMib
					.getIfPhysAddress());

			if (vedorName.equals("")) {
				interfaceTableCellArray[IFPHYSADDRESS_POS] = nodeInterfaceMib
						.getIfPhysAddress();
			} else {
				interfaceTableCellArray[IFPHYSADDRESS_POS] = nodeInterfaceMib
						.getIfPhysAddress()
						+ "  ( " + vedorName + " )";
			}

			interfaceTableCellArray[IFSTATUS_POS] = nodeInterfaceMib
					.getIfStatus();

			TableItem item = new TableItem(table, SWT.NULL);
			item.setText(interfaceTableCellArray);
			item.setData(interfaceTableCellArray);

			/*
			 * C^tF[XԂUP̏ꍇ͕BLUEF
			 */
			if (nodeInterfaceMib.getIfStatus().equals(
					DBTableInterfaceMIB.UP_STATUS)) {
				item.setForeground(Display.getCurrent().getSystemColor(
						SWT.COLOR_BLUE));
			}
		}
	}

	private String searchVedorID(String ifPhysAddress) {
		String vedorID = "";
		int head = "0X".length();

		if ((ifPhysAddress == null) || ifPhysAddress.equals("")
				|| (ifPhysAddress.length() < 8)) {
			return vedorID;
		}

		String work = ifPhysAddress.substring(head, head + OUI_LENGTH);
		String searchVendorID = work.toUpperCase();

		Map macInfoHashMap = MacAddressConfig.getInstance()
				.getResourceFileParse().getMacInfoHashMap();

		if (macInfoHashMap.containsKey(searchVendorID)) {
			MacAddressInfo macInfo = (MacAddressInfo) macInfoHashMap
					.get(searchVendorID);
			vedorID = macInfo.getVendorInfo();
		}

		return vedorID;
	}

	/*
	 * Interface MIBIndexɎ擾ăXgɊi[ĕԂ܂B
	 * 
	 * @return Interface MIB񃊃Xg
	 */
	private ArrayList getInterfaceMib(NodeInformation refreshNodeInfo,
			boolean isShowErrorDialog, boolean isSocket) {
		ArrayList interfaceMibList = null;

		if (!isSocket) {
			/* f[^x[XInterface MIB擾 */
			DBTableInterfaceMIB interfaceMibDBtable = DBTableInterfaceMIB
					.getInstance();

			try {
				interfaceMibList = interfaceMibDBtable.findSNMPInterfaces(
						refreshNodeInfo.getIpaddress(), true);
			} catch (DatabaseConnectionException e2) {
				logger.warning(e2.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e2.getMessage());
					shell.dispose();
				}
			} catch (SQLException e2) {
				logger.warning(e2.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e2.getMessage());
					shell.dispose();
				}
			}
		} else {
			/* T[oSocketɂInterface MIB擾 */
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			ConnectionInterfaceMib connectInterfaceMib = new ConnectionInterfaceMib(
					engineAddress);

			try {
				interfaceMibList = connectInterfaceMib
						.getInterfaceMib(refreshNodeInfo.getIpaddress());
			} catch (EngineConnectException e) {
				logger.warning("Node Interface MIB import error"
						+ e.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Engine connect error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);

					shell.dispose();
				}
			} catch (IOException e) {
				logger.warning("Node Interface MIB import error"
						+ e.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Engine connect error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				}
			}
		}

		return interfaceMibList;
	}

	/*
	 * J0iNo.j̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_NO_RATIO);
	}

	/*
	 * J1iIP Addressj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IP_RATIO);
	}

	/*
	 * J2iNode Namej̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_NODENAME_RATIO);
	}

	/*
	 * J3iIf Indexj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IFINDEX_RATIO);
	}

	/*
	 * J4iIf Descj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IFDESC_RATIO);
	}

	/*
	 * J5iIf Typej̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IFTYPE_RATIO);
	}

	/*
	 * J6iIf Mtuj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IFMTU_RATIO);
	}

	/*
	 * J7iIf speedj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol7Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IFSPEED_RATIO);
	}

	/*
	 * J8 (If Physaddress) ̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol8Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IFPHYSADDRESS_RATIO);
	}

	/*
	 * J9 (If Status) ̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol9Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN_IFSTATUS_RATIO);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/*
		 * InterfaceԂɍ킹ĕFZbgpColorIuWFNg CX^Xj
		 */
		if (textBackColor != null) {
			textBackColor.dispose();
		}

		if (table != null) {
			table.dispose();
		}
	}

	/**
	 * e[uColumn\[gNXpA\[g@\ MIBC^tF[X\e[u𐶐NX łB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class SnmpInterfaceMibTable extends AbstractTableView {
		/* e[uColumn click\[gtO */
		private boolean isCol0Direction = true;

		private boolean isCol1Direction = true;

		private boolean isCol2Direction = true;

		private boolean isCol3Direction = true;

		private boolean isCol4Direction = true;

		private boolean isCol5Direction = true;

		private boolean isCol6Direction = true;

		private boolean isCol7Direction = true;

		private boolean isCol8Direction = true;

		private boolean isCol9Direction = true;

		private TableColumn col0;

		private TableColumn col1;

		private TableColumn col2;

		private TableColumn col3;

		private TableColumn col4;

		private TableColumn col5;

		private TableColumn col6;

		private TableColumn col7;

		private TableColumn col8;

		private TableColumn col9;

		/*
		 * Interface MIB\e[u𐶐܂B
		 * 
		 */
		private Table createTable(Composite parent) {
			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;

			/* e[u */
			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);
			/* Column0(ifIndex) */
			col0 = new TableColumn(table, SWT.CENTER);
			col0.setText("No.");
			col0.setWidth(computeCol0Width());
			/* Column1(ifIndex) */
			col1 = new TableColumn(table, SWT.CENTER);
			col1.setText("IP Address");
			col1.setWidth(computeCol1Width());
			/* Column2(ifIndex) */
			col2 = new TableColumn(table, SWT.CENTER);
			col2.setText("Node Name");
			col2.setWidth(computeCol2Width());

			/* Column3(ifIndex) */
			col3 = new TableColumn(table, SWT.CENTER);
			col3.setText(DBTableInterfaceMIB.IF_INDEX);
			col3.setWidth(computeCol3Width());

			/* Column4(ifDesc) */
			col4 = new TableColumn(table, SWT.CENTER);
			col4.setText(DBTableInterfaceMIB.IF_DESC);
			col4.setWidth(computeCol4Width());

			/* Column5(ifType) */
			col5 = new TableColumn(table, SWT.CENTER);
			col5.setText(DBTableInterfaceMIB.IF_TYPE);
			col5.setWidth(computeCol5Width());

			/* Column6(ifMtu) */
			col6 = new TableColumn(table, SWT.CENTER);
			col6.setText(DBTableInterfaceMIB.IF_MTU);
			col6.setWidth(computeCol6Width());

			/* Column7(ifSpeed) */
			col7 = new TableColumn(table, SWT.CENTER);
			col7.setText(DBTableInterfaceMIB.IF_SPEED);
			col7.setWidth(computeCol7Width());

			/* Column8(ifPhysaddress) */
			col8 = new TableColumn(table, SWT.CENTER);
			col8.setText(DBTableInterfaceMIB.IF_PHYSADDRESS);
			col8.setWidth(computeCol8Width());

			/* Column9(ifStatus) */
			col9 = new TableColumn(table, SWT.CENTER);
			col9.setText(DBTableInterfaceMIB.IF_STATUS);
			col9.setWidth(computeCol9Width());

			/*
			 * e[uړꍇ͂TCYꍇ̃Xi[łB
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
							// nothing
						}

						/*
						 * e[uTCYɃe[uJZbg܂B
						 */
						public void controlResized(ControlEvent event) {
							setResizedTableColumnWidth();
						}
					});

			col0.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol0Direction = sortIntegerTable(table, NO_POS,
							isCol0Direction);
				}
			});
			col1.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol1Direction = sortTable(table, IP_ADDRESS_POS,
							isCol1Direction);
				}
			});
			col2.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol2Direction = sortTable(table, NODE_NAME_POS,
							isCol2Direction);
				}
			});

			col3.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol3Direction = sortIntegerTable(table, IFINDEX_POS,
							isCol3Direction);
				}
			});

			col4.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol4Direction = sortTable(table, IFDESC_POS,
							isCol4Direction);
				}
			});
			col5.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol5Direction = sortTable(table, IFTYPE_POS,
							isCol5Direction);
				}
			});
			col6.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* If Mtu J(l)\[gA\[gێ */
					isCol6Direction = sortIntegerTable(table, IFMTU_POS,
							isCol6Direction);
				}
			});
			col7.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* if Speed J(l)\[gA\[gێ */
					isCol7Direction = sortIntegerTable(table, IFSPEED_POS,
							isCol7Direction);
				}
			});
			col8.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol8Direction = sortTable(table, IFPHYSADDRESS_POS,
							isCol8Direction);
				}
			});
			col9.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol9Direction = sortTable(table, IFSTATUS_POS,
							isCol9Direction);
				}
			});

			return table;
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getEditorSite().getShell() != null) {
				if (getEditorSite().getShell().getSize() != null) {
					col0.setWidth(computeCol0Width());
					col1.setWidth(computeCol1Width());
					col2.setWidth(computeCol3Width());
					col3.setWidth(computeCol3Width());
					col4.setWidth(computeCol4Width());
					col5.setWidth(computeCol5Width());
					col6.setWidth(computeCol6Width());
					col7.setWidth(computeCol7Width());
					col8.setWidth(computeCol8Width());
					col9.setWidth(computeCol9Width());

				}
			}
		}

		/**
		 * X[p[NX̃e[uColumn Clickɂ\[g\bh
		 * I[o[ChāAe[uRowForegroundyBackground J[\[gɂĂێ܂B
		 * 
		 * @param table
		 *            Table
		 * @param item
		 *            TableItem
		 * @param strs
		 *            Table item
		 * @return TableItem
		 * @see netjfwatcher.common.view.AbstractTableView#setTableItem
		 *      (org.eclipse.swt.widgets.Table, org.eclipse.swt.widgets.
		 *      TableItem, java.lang.String[])
		 */
		protected TableItem setTableItem(Table table, TableItem item,
				String[] strs) {
			Object obj0 = item.getForeground();
			Object obj1 = item.getBackground();

			item.dispose();
			item = new TableItem(table, SWT.NONE);

			item.setText(strs);
			item.setData(strs);

			item.setForeground((Color) obj0);
			item.setBackground((Color) obj1);

			return item;
		}
	}
}
