/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcherrcpnetworkcamera.actions;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netwatcher.networkcamera.gui.editor.EditorNetworkCameraConfigView;
import netwatcher.networkcamera.gui.editor.EditorNetworkCameraView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * Network CameraɊւANV`NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNetworkCamera extends Action {
	/* MO */
	private static Logger logger;

	/*
	 * m[hViewō\\EditorPartEditorPart
	 * JxɁAUEditorPartCloseĂOpen
	 */
	private IEditorPart editorNodeConfigView;

	private IAction networkCameraAction = new ActionNetworkCamera();

	private IAction networkCameraActionSocket = new ActionNetworkCameraSocket();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	public ActionBuilderNetworkCamera() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public IAction getActionNetworkCamera() {
		return networkCameraAction;
	}

	public IAction getActionNetworkCameraSocket() {
		return networkCameraActionSocket;
	}

	private abstract class AbstractNetworkCameraAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANVs^XNłB
		 * 
		 */
		protected abstract void doTask();
	}

	public class ActionNetworkCamera extends AbstractNetworkCameraAction {

		protected NodeInformation nodeInfo;

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor
					.createFromURL(bundle
							.getEntry(MenuPreference.NETWORK_CAMERA_NODE_VIEW_IMAGE_FILE));
		}

		public String getText() {
			return MenuPreference.NETWORK_CAMERA_NODE_VIEW;
		}

		public String getToolTipText() {
			return MenuPreference.NETWORK_CAMERA_NODE_VIEW_TOOL_TIP;
		}

		protected void doTask() {

			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			if (editorNodeConfigView != null) {
				activePage.closeEditor(editorNodeConfigView, false);
				editorNodeConfigView = null;
			}
			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";
			try {
				activePage.openEditor(new EditorInputNodeView(nodeName
						+ EditorNetworkCameraConfigView.TITLE_SUFFIX, nodeInfo,
						false), EditorNetworkCameraConfigView.class.getName());

				activePage.openEditor(
						new EditorInputNodeView(nodeName
								+ EditorNetworkCameraView.TITLE_SUFFIX,
								nodeInfo, false), EditorNetworkCameraView.class
								.getName());

			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo
		 *            m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}

	public class ActionNetworkCameraSocket extends ActionNetworkCamera {

		protected void doTask() {

			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			if (editorNodeConfigView != null) {
				activePage.closeEditor(editorNodeConfigView, false);
				editorNodeConfigView = null;
			}

			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";
			try {
				activePage.openEditor(new EditorInputNodeView(nodeName
						+ EditorNetworkCameraConfigView.TITLE_SUFFIX, nodeInfo,
						true), EditorNetworkCameraConfigView.class.getName());

				activePage.openEditor(
						new EditorInputNodeView(nodeName
								+ EditorNetworkCameraView.TITLE_SUFFIX,
								nodeInfo, true), EditorNetworkCameraView.class
								.getName());

			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}
	}
}
