/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public final class Log4JLogger
implements Log {
    private static final String FQCN = (class$org$apache$commons$logging$impl$Log4JLogger == null ? (class$org$apache$commons$logging$impl$Log4JLogger = Log4JLogger.class$("org.apache.commons.logging.impl.Log4JLogger")) : class$org$apache$commons$logging$impl$Log4JLogger).getName();
    private static boolean initialized = false;
    private static String LAYOUT = "%r [%t] %p %c{2} %x - %m%n";
    private Logger logger = null;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$Log4JLogger;

    public Log4JLogger() {
        if (!initialized) {
            this.initialize();
        }
    }

    public Log4JLogger(String name) {
        if (!initialized) {
            this.initialize();
        }
        this.logger = Logger.getLogger((String)name);
    }

    public Log4JLogger(Logger logger) {
        if (!initialized) {
            this.initialize();
        }
        this.logger = logger;
    }

    private void initialize() {
        Logger root = Logger.getRootLogger();
        Enumeration appenders = root.getAllAppenders();
        if (appenders == null || !appenders.hasMoreElements()) {
            ConsoleAppender app = new ConsoleAppender((Layout)new PatternLayout(LAYOUT), "System.err");
            app.setName("commons-logging");
            root.addAppender((Appender)app);
            root.setPriority(Priority.INFO);
        }
        initialized = true;
    }

    public void trace(Object message) {
        this.logger.log(FQCN, Priority.DEBUG, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.logger.log(FQCN, Priority.DEBUG, message, t);
    }

    public void debug(Object message) {
        this.logger.log(FQCN, Priority.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.logger.log(FQCN, Priority.DEBUG, message, t);
    }

    public void info(Object message) {
        this.logger.log(FQCN, Priority.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.logger.log(FQCN, Priority.INFO, message, t);
    }

    public void warn(Object message) {
        this.logger.log(FQCN, Priority.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.logger.log(FQCN, Priority.WARN, message, t);
    }

    public void error(Object message) {
        this.logger.log(FQCN, Priority.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.logger.log(FQCN, Priority.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.logger.log(FQCN, Priority.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.log(FQCN, Priority.FATAL, message, t);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor(Priority.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Priority.WARN);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

