/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpv3;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;

public class UsmLocalizeKey
implements SecretKey {
    private static final long serialVersionUID = 1L;
    public static final String KEY_GEN_ALGO_HMAC_MD5 = "HmacMD5";
    public static final String KEY_GEN_ALGO_HMAC_SHA = "HmacSHA1";
    private String algorithm = null;
    private byte[] key = null;

    protected UsmLocalizeKey(String password, SnmpEngineID snmpEngineID, String algorithm) throws NoSuchAlgorithmException {
        if (algorithm.equals(KEY_GEN_ALGO_HMAC_MD5)) {
            this.algorithm = KEY_GEN_ALGO_HMAC_MD5;
            this.key = this.passwordToKeyMD5(password, snmpEngineID);
        } else if (algorithm.equals(KEY_GEN_ALGO_HMAC_SHA)) {
            this.algorithm = KEY_GEN_ALGO_HMAC_SHA;
            this.key = this.passwordToKeySHA(password, snmpEngineID);
        } else {
            throw new NoSuchAlgorithmException(new StringBuffer("Unsupported algorithm: ").append(algorithm).toString());
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        int length = this.key.length;
        byte[] array = new byte[length];
        System.arraycopy(this.key, 0, array, 0, length);
        return array;
    }

    public String getFormat() {
        return "RAW";
    }

    private byte[] passwordToKeyMD5(String password, SnmpEngineID snmpEngineID) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] buff = new byte[64];
        byte[] passwd = password.getBytes();
        byte[] engineID = snmpEngineID.getId();
        int count = 0;
        int index = 0;
        while (count < 0x100000) {
            int i = 0;
            while (i < 64) {
                buff[i] = passwd[index++ % passwd.length];
                ++i;
            }
            md.update(buff, 0, 64);
            count += 64;
        }
        byte[] key = md.digest();
        int i = 0;
        while (i < 16) {
            buff[i] = key[i];
            ++i;
        }
        i = 0;
        while (i < engineID.length) {
            buff[i + 16] = engineID[i];
            ++i;
        }
        i = 0;
        while (i < 16) {
            buff[i + 16 + engineID.length] = key[i];
            ++i;
        }
        md.update(buff, 0, 32 + engineID.length);
        return md.digest();
    }

    private byte[] passwordToKeySHA(String password, SnmpEngineID snmpEngineID) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] buff = new byte[72];
        byte[] passwd = password.getBytes();
        byte[] engineID = snmpEngineID.getId();
        int count = 0;
        int index = 0;
        while (count < 0x100000) {
            int i = 0;
            while (i < 64) {
                buff[i] = passwd[index++ % passwd.length];
                ++i;
            }
            md.update(buff, 0, 64);
            count += 64;
        }
        byte[] key = md.digest();
        int i = 0;
        while (i < 20) {
            buff[i] = key[i];
            ++i;
        }
        i = 0;
        while (i < engineID.length) {
            buff[i + 20] = engineID[i];
            ++i;
        }
        i = 0;
        while (i < 20) {
            buff[i + 20 + engineID.length] = key[i];
            ++i;
        }
        md.update(buff, 0, 40 + engineID.length);
        return md.digest();
    }
}

