/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.octetstring;

import java.util.StringTokenizer;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;

public class SnmpIPAddress
extends SnmpOctetString {
    private static final int IPADDRESS_LENGTH = 4;

    public SnmpIPAddress() {
        this.dataArray = new byte[4];
        int i = 0;
        while (i < 4) {
            this.dataArray[i] = 0;
            ++i;
        }
        this.tag = (byte)64;
        this.tagDescription = "IPADDRESS";
    }

    public SnmpIPAddress(String string) throws SnmpBadValueException {
        this.dataArray = this.parseIPAddress(string);
        this.tag = (byte)64;
        this.tagDescription = "IPADDRESS";
    }

    public SnmpIPAddress(byte[] enc) throws SnmpBadValueException {
        this.tag = (byte)64;
        this.tagDescription = "IPADDRESS";
        if (enc.length != 4) {
            throw new SnmpBadValueException(" IPAddress: bad BER encoding supplied to set value ");
        }
        this.dataArray = enc;
    }

    public void setValue(Object newAddress) throws SnmpBadValueException {
        if (newAddress instanceof byte[] && ((byte[])newAddress).length == 4) {
            this.dataArray = (byte[])newAddress;
        } else if (newAddress instanceof String) {
            this.dataArray = this.parseIPAddress((String)newAddress);
        } else {
            throw new SnmpBadValueException(" IPAddress: bad data supplied to set value ");
        }
    }

    public String toString() {
        String returnString = "";
        if (this.dataArray.length > 0) {
            int convert = this.dataArray[0];
            if (convert < 0) {
                convert += 256;
            }
            returnString = String.valueOf(returnString) + convert;
            int i = 1;
            while (i < this.dataArray.length) {
                convert = this.dataArray[i];
                if (convert < 0) {
                    convert += 256;
                }
                returnString = String.valueOf(returnString) + "." + convert;
                ++i;
            }
        }
        return returnString;
    }

    private byte[] parseIPAddress(String addressString) throws SnmpBadValueException {
        try {
            StringTokenizer st = new StringTokenizer(addressString, " .");
            int size = 0;
            while (st.hasMoreTokens()) {
                ++size;
                st.nextToken();
            }
            if (size != 4) {
                throw new SnmpBadValueException(" IPAddress: wrong number of components supplied to set value ");
            }
            byte[] returnBytes = new byte[size];
            st = new StringTokenizer(addressString, " .");
            int i = 0;
            while (i < size) {
                int addressComponent = Integer.parseInt(st.nextToken());
                if (addressComponent < 0 || addressComponent > 255) {
                    throw new SnmpBadValueException(" IPAddress: invalid component supplied to set value ");
                }
                returnBytes[i] = (byte)addressComponent;
                ++i;
            }
            return returnBytes;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SnmpBadValueException(" IPAddress: invalid component supplied to set value ");
        }
    }
}

