/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.math.BigInteger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;

public class SnmpUInteger32
extends SnmpInteger {
    private static BigInteger maxValue = new BigInteger("4294967295");

    public SnmpUInteger32() {
        this(0L);
    }

    public SnmpUInteger32(long newValue) {
        this.integerValue = new BigInteger(Long.toString(newValue));
        this.integerValue = this.integerValue.mod(maxValue);
        this.tag = (byte)71;
        this.tagDescription = "INTEGER32";
    }

    public SnmpUInteger32(byte[] enc) throws SnmpBadValueException {
        this.extractValueFromBEREncoding(enc);
        this.integerValue = this.integerValue.mod(maxValue);
        this.tag = (byte)71;
        this.tagDescription = "INTEGER32";
    }

    public void setValue(Object newValue) throws SnmpBadValueException {
        if (newValue instanceof BigInteger) {
            this.integerValue = (BigInteger)newValue;
            this.integerValue = this.integerValue.mod(maxValue);
        } else if (newValue instanceof Integer) {
            this.integerValue = new BigInteger(newValue.toString());
            this.integerValue = this.integerValue.mod(maxValue);
        } else if (newValue instanceof String) {
            try {
                this.integerValue = new BigInteger((String)newValue);
                this.integerValue = this.integerValue.mod(maxValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpBadValueException(" Unsigned Integer: bad object supplied to set value ");
            }
        } else {
            throw new SnmpBadValueException(" Unsigned Integer: bad object supplied to set value ");
        }
    }
}

