/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderDataExport;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditorNodeSnmpStatisticsData
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Snmp Statistics Data View";
    public static final int TEXT_WIDTH = 100;
    public static final int COUNT_TEXT_WIDTH = 70;
    public static final int DATE_TEXT_WIDTH = 150;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{900, 800};
    private static Logger logger;
    private static final float COLUMN0_DATE_RATIO = 0.1f;
    private static final float COLUMN1_DATA_RATIO = 0.15f;
    private ActionBuilderDataExport exportAction = new ActionBuilderDataExport();
    private ActionBuilderChart nodeChart = new ActionBuilderChart();
    private ArrayList oidInstanceList = new ArrayList();
    private ArrayList nameList = new ArrayList();
    private ArrayList dateList = new ArrayList();
    private ArrayList allStatisticsDataList = new ArrayList();
    private NodeInformation targetNodeInfo;
    private String inputOid;
    private String period;
    private String thresHold;
    private String thresHoldType;
    private String startDate;
    private String endDate;
    private String[] maxData;
    private String[] minData;
    private Text oidInstanceCountText;
    private Text dataTotalCountText;
    private Text periodText;
    private Text threshHoldText;
    private Text threshHoldTypeText;
    private Text startDateText;
    private Text endDateText;
    private Button refreshButton;
    private TableViewer viewer;

    public EditorNodeSnmpStatisticsData() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        logger.info("NodeSnmpView createPartControl start");
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        if (this.targetNodeInfo == null) {
            logger.warning("NodeInfo null");
        }
        this.inputOid = nodeViewEditorInput.getOid();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite((Composite)scrollComposite, 16384);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData(2));
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(12, false);
        Composite composite = new Composite(baseComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        this.refreshButton = new Button(composite, 0);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setLayoutData((Object)new GridData());
        Label label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("OID Instance=");
        label.setLayoutData((Object)new GridData());
        this.oidInstanceCountText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.oidInstanceCountText.setEnabled(false);
        this.oidInstanceCountText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Total Data=");
        label.setLayoutData((Object)new GridData());
        this.dataTotalCountText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.dataTotalCountText.setEnabled(false);
        this.dataTotalCountText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Period(sec)=");
        label.setLayoutData((Object)new GridData());
        this.periodText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.periodText.setEnabled(false);
        this.periodText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Threshold=");
        label.setLayoutData((Object)new GridData());
        this.threshHoldText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.threshHoldText.setEnabled(false);
        this.threshHoldText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Threshold Type=");
        label.setLayoutData((Object)new GridData());
        this.threshHoldTypeText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.threshHoldTypeText.setEnabled(false);
        this.threshHoldTypeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Start Date=");
        label.setLayoutData((Object)new GridData());
        this.startDateText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.startDateText.setEnabled(false);
        this.startDateText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("End Date=");
        label.setLayoutData((Object)new GridData());
        this.endDateText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.endDateText.setEnabled(false);
        this.endDateText.setLayoutData((Object)gridData);
        try {
            this.getStatisticsMibInfo(this.targetNodeInfo.getIpaddress(), this.inputOid);
        }
        catch (DatabaseConnectionException e1) {
            logger.warning("Abort statistics data get" + e1.getMessage());
        }
        catch (SQLException e1) {
            logger.warning("Abort statistics data get" + e1.getMessage());
        }
        StatisticsTable statisticsTable = new StatisticsTable();
        this.table = statisticsTable.createTable(baseComposite);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setTableStatisticsData();
        this.setTextNodeInfo();
        this.createContextMenu();
        this.refreshButton.addSelectionListener(new SelectionListener(){

            /*
             * Unable to fully structure code
             */
            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmpStatisticsData.access$4(EditorNodeSnmpStatisticsData.this).setEnabled(false);
                try {
                    try {
                        EditorNodeSnmpStatisticsData.access$7(EditorNodeSnmpStatisticsData.this, EditorNodeSnmpStatisticsData.access$5(EditorNodeSnmpStatisticsData.this).getIpaddress(), EditorNodeSnmpStatisticsData.access$6(EditorNodeSnmpStatisticsData.this));
                        EditorNodeSnmpStatisticsData.access$8(EditorNodeSnmpStatisticsData.this);
                        EditorNodeSnmpStatisticsData.access$9(EditorNodeSnmpStatisticsData.this);
                    }
                    catch (DatabaseConnectionException ex) {
                        shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Abort statistics data get", (String)ex.getMessage());
                        EditorNodeSnmpStatisticsData.access$10().warning("Abort statistics data get" + ex.getMessage());
                        shell.dispose();
lbl13:
                        // 2 sources

                        while (true) {
                            EditorNodeSnmpStatisticsData.access$4(EditorNodeSnmpStatisticsData.this).setEnabled(true);
                            return;
                        }
                    }
                    catch (SQLException ex) {
                        shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Abort statistics data get", (String)ex.getMessage());
                        EditorNodeSnmpStatisticsData.access$10().warning("Abort statistics data get" + ex.getMessage());
                        shell.dispose();
                        ** continue;
                    }
                }
                finally {
                    EditorNodeSnmpStatisticsData.access$4(EditorNodeSnmpStatisticsData.this).setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditorNodeSnmpStatisticsData.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        if (this.table.getSelectionIndex() >= 0 && this.table.getSelection() != null) {
            ((ActionBuilderDataExport.ActionExportSnmpStatisticsData)this.exportAction.getActionExportSnmpStatistics()).setTable(this.table);
            manager.add(this.exportAction.getActionExportSnmpStatistics());
            String title = String.valueOf(this.targetNodeInfo.getNodename()) + "(" + this.targetNodeInfo.getIpaddress() + ") " + " OID=" + this.inputOid + " Chart";
            if (!this.isSocket) {
                ActionBuilderChart.ActionNodeSnmpStatisticsChartView actionSnmpStatistics = (ActionBuilderChart.ActionNodeSnmpStatisticsChartView)this.nodeChart.getActionNodeSnmpStatisticsChartView();
                actionSnmpStatistics.setText("Chart OID=" + this.inputOid);
                actionSnmpStatistics.setToolTipText("Chart OID=" + this.inputOid);
                actionSnmpStatistics.setTitle(title);
                actionSnmpStatistics.setNodeInfo(this.targetNodeInfo);
                actionSnmpStatistics.setOid(this.inputOid);
                actionSnmpStatistics.setMaxData(this.maxData);
                actionSnmpStatistics.setMinData(this.minData);
                actionSnmpStatistics.setDateList(this.dateList);
                actionSnmpStatistics.setDataList(this.allStatisticsDataList);
                actionSnmpStatistics.setNameList(this.nameList);
                manager.add(this.nodeChart.getActionNodeSnmpStatisticsChartView());
            } else {
                ActionBuilderChart.ActionNodeSnmpStatisticsChartViewSocket actionSnmpStatistics = (ActionBuilderChart.ActionNodeSnmpStatisticsChartViewSocket)this.nodeChart.getActionNodeSnmpStatisticsChartViewSocket();
                actionSnmpStatistics.setText("Chart OID=" + this.inputOid);
                actionSnmpStatistics.setToolTipText("Chart OID=" + this.inputOid);
                actionSnmpStatistics.setTitle(title);
                actionSnmpStatistics.setNodeInfo(this.targetNodeInfo);
                actionSnmpStatistics.setOid(this.inputOid);
                actionSnmpStatistics.setMaxData(this.maxData);
                actionSnmpStatistics.setMinData(this.minData);
                actionSnmpStatistics.setDateList(this.dateList);
                actionSnmpStatistics.setDataList(this.allStatisticsDataList);
                actionSnmpStatistics.setNameList(this.nameList);
                manager.add(this.nodeChart.getActionNodeSnmpStatisticsChartViewSocket());
            }
        }
    }

    private void setTextNodeInfo() {
        this.oidInstanceCountText.setText(Integer.toString(this.oidInstanceList.size()));
        this.dataTotalCountText.setText(Integer.toString(this.dateList.size()));
        if (this.period != null) {
            this.periodText.setText(this.period);
        }
        if (this.thresHold != null) {
            this.threshHoldText.setText(this.thresHold);
        }
        if (this.thresHoldType != null) {
            this.threshHoldTypeText.setText(this.thresHoldType);
        }
        if (this.startDate != null) {
            this.startDateText.setText(this.startDate);
        }
        if (this.endDate != null) {
            this.endDateText.setText(this.endDate);
        }
    }

    private void setTableStatisticsData() {
        this.table.removeAll();
        this.viewer.refresh();
        int dateCount = 0;
        while (dateCount < this.dateList.size()) {
            ArrayList[] statisticsDataList = new ArrayList[this.allStatisticsDataList.size()];
            String[] statisticsMibTableCellArray = new String[this.oidInstanceList.size() + 1];
            statisticsMibTableCellArray[0] = (String)this.dateList.get(dateCount);
            int instanceCount = 0;
            while (instanceCount < this.allStatisticsDataList.size()) {
                statisticsDataList[instanceCount] = (ArrayList)this.allStatisticsDataList.get(instanceCount);
                statisticsMibTableCellArray[instanceCount + 1] = (String)statisticsDataList[instanceCount].get(dateCount);
                ++instanceCount;
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(statisticsMibTableCellArray);
            item.setData((Object)statisticsMibTableCellArray);
            ++dateCount;
        }
    }

    private void getStatisticsMibInfo(String ipAddress, String selectOid) throws DatabaseConnectionException, SQLException {
        ArrayList ifDescriptorList = null;
        DBTableStatisticsMIBControl mibDBTable = null;
        String engineAddress = "";
        if (!this.isSocket) {
            mibDBTable = DBTableStatisticsMIBControl.getInstance();
            ifDescriptorList = mibDBTable.findIfDescriptor(ipAddress);
        } else {
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand("If_Desc_Get");
            control.setIpaddress(ipAddress);
            engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
            try {
                StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(control);
                ifDescriptorList = mibproperty.getMibIfDescriptorList();
            }
            catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
                return;
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
                return;
            }
        }
        if (ifDescriptorList == null) {
            return;
        }
        this.oidInstanceList.clear();
        this.nameList.clear();
        this.dateList.clear();
        this.allStatisticsDataList.clear();
        int i = 0;
        while (i < ifDescriptorList.size()) {
            StatisticsMibIfDescriptor mibIfDesc = (StatisticsMibIfDescriptor)ifDescriptorList.get(i);
            String workOid = mibIfDesc.getOid();
            int checkPoint = "Oid=".length();
            if (checkPoint >= 0 && workOid.substring(checkPoint).equals(selectOid)) {
                this.oidInstanceList.add(mibIfDesc.getInstance());
                if (mibIfDesc.getIfDescriptor().equals("")) {
                    this.nameList.add(mibIfDesc.getInstance());
                } else {
                    this.nameList.add(String.valueOf(mibIfDesc.getInstance()) + " (" + mibIfDesc.getIfDescriptor() + ")");
                }
            }
            ++i;
        }
        ArrayList statisticsMibSetStatusList = null;
        if (!this.isSocket) {
            statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
        } else {
            System.out.println("Socket1");
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand("Statistics_Set_Status_Get");
            control.setIpaddress(ipAddress);
            ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
            try {
                StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(control);
                if (mibproperty != null) {
                    statisticsMibSetStatusList = mibproperty.getStatisticsMibSetList();
                }
            }
            catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
                return;
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
                return;
            }
        }
        String readOid = "";
        int i2 = 0;
        while (i2 < statisticsMibSetStatusList.size()) {
            StatisticsMibSetStatus statisticsMibSetStatus = (StatisticsMibSetStatus)statisticsMibSetStatusList.get(i2);
            readOid = statisticsMibSetStatus.getReadOid();
            if (readOid.equals(selectOid)) {
                this.period = statisticsMibSetStatus.getReadPeriod();
                this.thresHold = statisticsMibSetStatus.getReadThreshold();
                this.thresHoldType = statisticsMibSetStatus.getReadThresholdType().equals("") ? "none" : statisticsMibSetStatus.getReadThresholdType();
            }
            ++i2;
        }
        this.maxData = new String[this.oidInstanceList.size()];
        this.minData = new String[this.oidInstanceList.size()];
        StatisticsMibProperty mibProperty = null;
        int k = 0;
        while (k < this.oidInstanceList.size()) {
            String oidIns = (String)this.oidInstanceList.get(k);
            if (!this.isSocket) {
                mibProperty = mibDBTable.getDataCount(ipAddress, selectOid, oidIns);
            } else {
                StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
                statisticsMibControl.setSubCommand("Statistics_Data_Get");
                statisticsMibControl.setIpaddress(ipAddress);
                statisticsMibControl.setOid(selectOid);
                statisticsMibControl.setOidInstance(oidIns);
                ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
                try {
                    mibProperty = statisticsMibGet.getStatisticsMib(statisticsMibControl);
                }
                catch (EngineConnectException e) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                    return;
                }
                catch (IOException e) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                    return;
                }
            }
            if (mibProperty.getTotalDataCount() == 0 || mibProperty.getStartDate() == null || mibProperty.getEndDate() == null) {
                return;
            }
            this.startDate = mibProperty.getStartDate().toString();
            this.endDate = mibProperty.getEndDate().toString();
            this.maxData[k] = mibProperty.getMaxData();
            this.minData[k] = mibProperty.getMinData();
            ++k;
        }
        String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
        String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
        String filterStart = filterCheckStart == null || filterCheckStart.equals("") ? this.startDate : filterCheckStart;
        String filterEnd = filterCheckEnd == null || filterCheckEnd.equals("") ? this.endDate : filterCheckEnd;
        int limit = DataFilterInfo.getInstance().getLimit();
        int j = 0;
        while (j < this.oidInstanceList.size()) {
            String instance = (String)this.oidInstanceList.get(j);
            ArrayList<String> instanceDataList = new ArrayList<String>();
            ArrayList dataList = null;
            if (!this.isSocket) {
                dataList = mibDBTable.findInstance(ipAddress, selectOid, instance, filterStart, filterEnd);
            } else {
                StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
                statisticsMibControl.setSubCommand("Statistics_Data_Get");
                statisticsMibControl.setIpaddress(ipAddress);
                statisticsMibControl.setOid(selectOid);
                statisticsMibControl.setOidInstance(instance);
                statisticsMibControl.setPeriodStartDate(filterStart);
                statisticsMibControl.setPeriodEndDate(filterEnd);
                ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
                try {
                    StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(statisticsMibControl);
                    dataList = mibproperty.getMibInfoList();
                }
                catch (EngineConnectException e) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                    return;
                }
                catch (IOException e) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                    return;
                }
            }
            int i3 = 0;
            while (i3 < dataList.size()) {
                StatisticsMibInfo statisticsMibInfo = (StatisticsMibInfo)dataList.get(i3);
                if (j == 0) {
                    this.dateList.add(statisticsMibInfo.getDate().toString());
                }
                instanceDataList.add(statisticsMibInfo.getStatisMibValue());
                if (limit != 0 && i3 >= limit) break;
                ++i3;
            }
            this.allStatisticsDataList.add(instanceDataList);
            ++j;
        }
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    static /* synthetic */ Button access$4(EditorNodeSnmpStatisticsData editorNodeSnmpStatisticsData) {
        return editorNodeSnmpStatisticsData.refreshButton;
    }

    static /* synthetic */ NodeInformation access$5(EditorNodeSnmpStatisticsData editorNodeSnmpStatisticsData) {
        return editorNodeSnmpStatisticsData.targetNodeInfo;
    }

    static /* synthetic */ String access$6(EditorNodeSnmpStatisticsData editorNodeSnmpStatisticsData) {
        return editorNodeSnmpStatisticsData.inputOid;
    }

    static /* synthetic */ void access$7(EditorNodeSnmpStatisticsData editorNodeSnmpStatisticsData, String string, String string2) throws DatabaseConnectionException, SQLException {
        editorNodeSnmpStatisticsData.getStatisticsMibInfo(string, string2);
    }

    static /* synthetic */ void access$8(EditorNodeSnmpStatisticsData editorNodeSnmpStatisticsData) {
        editorNodeSnmpStatisticsData.setTableStatisticsData();
    }

    static /* synthetic */ void access$9(EditorNodeSnmpStatisticsData editorNodeSnmpStatisticsData) {
        editorNodeSnmpStatisticsData.setTextNodeInfo();
    }

    static /* synthetic */ Logger access$10() {
        return logger;
    }

    private final class StatisticsTable
    extends AbstractTableView {
        private boolean[] isColDirection;

        private StatisticsTable() {
        }

        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            this.isColDirection = new boolean[EditorNodeSnmpStatisticsData.this.oidInstanceList.size() + 1];
            TableColumn[] col = new TableColumn[EditorNodeSnmpStatisticsData.this.oidInstanceList.size() + 1];
            col[0] = new TableColumn(this.table, 0x1000000);
            col[0].setText("Date");
            col[0].setWidth(EditorNodeSnmpStatisticsData.this.computeCol0Width());
            this.isColDirection[0] = true;
            col[0].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ((StatisticsTable)StatisticsTable.this).isColDirection[0] = StatisticsTable.this.sortTable(StatisticsTable.this.table, 0, StatisticsTable.this.isColDirection[0], null);
                }
            });
            int i = 1;
            while (i < col.length) {
                col[i] = new TableColumn(this.table, 0x1000000);
                col[i].setText((String)EditorNodeSnmpStatisticsData.this.nameList.get(i - 1));
                col[i].setWidth(EditorNodeSnmpStatisticsData.this.computeCol1Width());
                this.isColDirection[i] = true;
                final int count = i;
                col[i].addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        ((StatisticsTable)StatisticsTable.this).isColDirection[count] = StatisticsTable.this.sortDoubleTable(StatisticsTable.this.table, count, StatisticsTable.this.isColDirection[count]);
                    }
                });
                ++i;
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    StatisticsTable.this.setResizedTableColumnWidth();
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
            if (EditorNodeSnmpStatisticsData.this.getEditorSite().getPage().isPartVisible(EditorNodeSnmpStatisticsData.this.getEditorSite().getPart()) && EditorNodeSnmpStatisticsData.this.getEditorSite().getShell() != null) {
                EditorNodeSnmpStatisticsData.this.getEditorSite().getShell().getSize();
            }
        }
    }
}

