/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.ping;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionPing;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.PingInfo;
import netjfwatcher.engine.socket.info.PingProperty;
import netjfwatcher.engine.socket.info.PingResponseInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class EditorNodePingChart
extends AbstractEditorNodeChart {
    private static Logger logger;
    private ArrayList pingDataList = new ArrayList();
    private PingResponseInfo responseInfo = new PingResponseInfo();

    public EditorNodePingChart() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void setPopupMenu(Composite parent) {
        if (this.itemNameList != null) {
            this.popUpMenu = new Menu((Decorations)parent.getShell(), 8);
            this.canvas.setMenu(this.popUpMenu);
            MenuItem menuItemRefresh = new MenuItem(this.popUpMenu, 0);
            menuItemRefresh.setText("Refresh");
            menuItemRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        EditorNodePingChart.this.getChartData();
                    }
                    catch (DatabaseConnectionException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (SQLException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                    EditorNodePingChart.access$1("all");
                    EditorNodePingChart.this.selectNo = 0;
                    EditorNodePingChart.this.redraw();
                }
            });
        }
    }

    protected void getChartData() throws DatabaseConnectionException, SQLException {
        if (this.maxData == null) {
            this.maxData = new String[1];
            this.minData = new String[1];
            this.dateList = new ArrayList();
            this.pingDataList = new ArrayList();
            this.allStatisticsDataList = new ArrayList();
        } else {
            this.dateList.clear();
            this.pingDataList.clear();
            this.allStatisticsDataList.clear();
        }
        ArrayList dataList = null;
        PingProperty property = null;
        String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
        String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
        String filterStart = filterCheckStart == null || filterCheckStart.equals("") ? null : filterCheckStart;
        String filterEnd = filterCheckEnd == null || filterCheckEnd.equals("") ? null : filterCheckEnd;
        int limit = DataFilterInfo.getInstance().getLimit();
        if (!this.isSocket) {
            DBTablePingResponse pingDBTable = DBTablePingResponse.getInstance();
            dataList = pingDBTable.findAll(this.targetNodeInfo.getIpaddress(), filterStart, filterEnd);
            property = pingDBTable.getDataCount(this.targetNodeInfo.getIpaddress());
        } else {
            Shell shell;
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            try {
                ConnectionPing connectionPing = new ConnectionPing(engineAddress);
                PingResponseInfo pingResponseInfo = connectionPing.getPingInfo(this.targetNodeInfo.getIpaddress(), filterStart, filterEnd);
                dataList = pingResponseInfo.getPingDataList();
                property = pingResponseInfo.getPingProperty();
            }
            catch (EngineConnectException e) {
                shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                logger.warning("Engine connect error " + e.getMessage() + " Engine=" + engineAddress);
                shell.dispose();
                e.printStackTrace();
            }
            catch (IOException e) {
                shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                logger.warning("Engine connect error " + e.getMessage() + " Engine=" + engineAddress);
                shell.dispose();
                e.printStackTrace();
            }
        }
        if (dataList != null && property != null && dataList.size() > 0) {
            this.maxData[0] = property.getMaxData();
            this.minData[0] = property.getMinData();
        }
        this.responseInfo.setPingDataList(dataList);
        this.responseInfo.setPingProperty(property);
        if (this.responseInfo == null) {
            return;
        }
        ArrayList workPingDataList = this.responseInfo.getPingDataList();
        if (workPingDataList == null) {
            return;
        }
        int i = 0;
        while (i < workPingDataList.size()) {
            PingInfo pingIinfo = (PingInfo)workPingDataList.get(i);
            this.dateList.add(pingIinfo.getPingCheckDate().toString());
            this.pingDataList.add(Long.toString(pingIinfo.getPingDiffTime()));
            if (limit != 0 && i >= limit) break;
            ++i;
        }
        this.allStatisticsDataList.add(this.pingDataList);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    static /* synthetic */ void access$1(String string) {
        AbstractEditorNodeChart.mode = string;
    }
}

