/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.view.editorpart.alarm.AlarmListTableViewLabelProvider;
import netjfwatcher.engine.view.editorpart.alarm.AlarmTableTimerProcessor;
import netjfwatcher.engine.view.editorpart.alarm.EditorNodeAlarm;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditorAllNodeAlarm
extends EditorNodeAlarm {
    private static Logger logger;
    public static final String TITLE_SUFFIX = " All Alarm View";
    private static final String ALARM_ALL = "all";
    private AlarmAction alarmAction = new AlarmAction();
    private Display display;
    private AlarmTableTimerProcessor timerProcessor;
    private Button checkStartButton;
    private Button checkStopButton;
    private boolean isRefresh = false;

    public EditorAllNodeAlarm() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.isSocket = nodeViewEditorInput.isSocket();
        this.isRefresh = nodeViewEditorInput.isRefresh();
        AlarmTable alarmTable = new AlarmTable();
        this.table = alarmTable.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.createImage(parent);
        this.createContextMenu();
        this.setNodeAlarmeView(ALARM_ALL, this.sortColumn, this.sortDirection);
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 5));
        if (this.isRefresh) {
            this.alarmAction.refreshNodeAlarmTable();
        }
    }

    public void setNodeAlarmeView(String ipAddress, String sortColumn, String sortDirection) {
        this.table.removeAll();
        this.viewer.refresh();
        ArrayList alarmInfoList = this.getAlarmList(ipAddress, sortColumn, sortDirection);
        if (alarmInfoList == null) {
            return;
        }
        this.alarmCountText.setText(Integer.toString(alarmInfoList.size()));
        this.errorCount = 0;
        this.warningCount = 0;
        this.infoCount = 0;
        int i = 0;
        while (i < alarmInfoList.size()) {
            String[] alarmCellArray = new String[AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS.length];
            AlarmInformation alarmInfo = (AlarmInformation)alarmInfoList.get(i);
            alarmCellArray[0] = alarmInfo.getAlarmID();
            alarmCellArray[1] = alarmInfo.getAlarmDate();
            alarmCellArray[2] = alarmInfo.getNodename();
            alarmCellArray[3] = alarmInfo.getGroup();
            alarmCellArray[4] = alarmInfo.getIpaddress();
            alarmCellArray[5] = alarmInfo.getAlarmMessage();
            TableItem item = new TableItem(this.table, 0);
            item.setText(alarmCellArray);
            item.setData((Object)alarmCellArray);
            if (alarmInfo.getAlarmLevel().equals("ERROR")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmErrorLevelColor());
                item.setImage(5, this.errorImage);
                ++this.errorCount;
            } else if (alarmInfo.getAlarmLevel().equals("WARNING")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmWarningLevelColor());
                item.setImage(5, this.warningImage);
                ++this.warningCount;
            } else if (alarmInfo.getAlarmLevel().equals("INFO")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmInfoLevelColor());
                item.setImage(5, this.infoImage);
                ++this.infoCount;
            } else {
                logger.warning("Unknown alarm level : " + alarmInfo.getAlarmLevel());
            }
            ++i;
        }
        this.setStatusLine();
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditorAllNodeAlarm.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.alarmAction.getActionShowAllNodeAlarmListTable());
        if (this.table.getSelectionIndex() >= 0 && this.table.getSelection() != null) {
            TableItem[] item = this.table.getSelection();
            String[] alarmTableInfo = (String[])item[0].getData();
            if (!this.isSocket) {
                ((ActionBuilderAlarmList.ActionConfirmAlarm)this.alarmAction.getActionConfirmAlarm()).setConfirmAlarm(alarmTableInfo[0], alarmTableInfo[4]);
                manager.add(this.alarmAction.getActionConfirmAlarm());
            } else {
                ((ActionBuilderAlarmList.ActionConfirmAlarmSocket)this.alarmAction.getActionConfirmAlarmSocket()).setConfirmAlarm(alarmTableInfo[0], alarmTableInfo[4]);
                manager.add(this.alarmAction.getActionConfirmAlarmSocket());
            }
        }
        if (!this.isSocket) {
            ((ActionBuilderAlarmList.ActionConfirmAllAlarm)this.alarmAction.getActionConfirmAllAlarm()).setAlarmIPAddress(ALARM_ALL);
            manager.add(this.alarmAction.getActionConfirmAllAlarm());
        } else {
            ((ActionBuilderAlarmList.ActionConfirmAllAlarmSocket)this.alarmAction.getActionConfirmAllAlarmSocket()).setAlarmIPAddress(ALARM_ALL);
            manager.add(this.alarmAction.getActionConfirmAllAlarmSocket());
        }
    }

    private void startTimer() {
        if (!this.isSocket && this.timerProcessor == null) {
            AlarmTableTimerProcessor.getInstance().setDisplay(this.display);
            AlarmTableTimerProcessor.getInstance().setAlarmCountText(this.alarmCountText);
            this.timerProcessor = AlarmTableTimerProcessor.getInstance();
            this.display.timerExec(5000, (Runnable)this.timerProcessor);
        } else if (!this.isSocket && this.timerProcessor != null) {
            this.display.timerExec(5000, (Runnable)this.timerProcessor);
        }
    }

    private void stopTimer() {
        if (this.timerProcessor != null) {
            this.display.timerExec(-1, (Runnable)this.timerProcessor);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.timerProcessor != null) {
            this.display.timerExec(-1, (Runnable)this.timerProcessor);
        }
    }

    static /* synthetic */ Color access$5() {
        return AbstractEditorNodeView.WHITE_COLOR;
    }

    private final class AlarmTable
    extends AbstractTableView {
        private boolean isCol0Direction = false;
        private boolean isCol1Direction = true;
        private boolean isCol2Direction = true;
        private boolean isCol3Direction = true;
        private boolean isCol4Direction = true;
        private boolean isCol5Direction = true;
        private int[] imageColumn = new int[]{5};
        private TableColumn col0;
        private TableColumn col1;
        private TableColumn col2;
        private TableColumn col3;
        private TableColumn col4;
        private TableColumn col5;

        private AlarmTable() {
        }

        private Table createTable(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            parent.setLayout((Layout)gridLayout);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new RowLayout(256));
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            composite.setLayoutData((Object)data);
            Label labelAddress = new Label(composite, 0);
            labelAddress.setText("Alarm count");
            EditorAllNodeAlarm.this.alarmCountText = new Text(composite, 133128);
            EditorAllNodeAlarm.this.alarmCountText.setLayoutData((Object)new RowData(100, -1));
            EditorAllNodeAlarm.this.alarmCountText.setEditable(false);
            EditorAllNodeAlarm.this.alarmCountText.setEnabled(false);
            EditorAllNodeAlarm.this.alarmCountText.setBackground(EditorAllNodeAlarm.this.textBackColor);
            EditorAllNodeAlarm.this.refreshButton = new Button(composite, 0);
            EditorAllNodeAlarm.this.refreshButton.setText("Refresh");
            if (!EditorAllNodeAlarm.this.isSocket) {
                EditorAllNodeAlarm.this.checkStartButton = new Button(composite, 0);
                EditorAllNodeAlarm.this.checkStartButton.setText("Auto check start");
                EditorAllNodeAlarm.this.checkStopButton = new Button(composite, 0);
                EditorAllNodeAlarm.this.checkStopButton.setText("Auto check stop");
                EditorAllNodeAlarm.this.checkStartButton.setEnabled(true);
                EditorAllNodeAlarm.this.checkStopButton.setEnabled(false);
            }
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            EditorAllNodeAlarm.this.refreshButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    ((AlarmTable)AlarmTable.this).EditorAllNodeAlarm.this.refreshButton.setEnabled(false);
                    EditorAllNodeAlarm.this.setNodeAlarmeView(EditorAllNodeAlarm.ALARM_ALL, ((AlarmTable)AlarmTable.this).EditorAllNodeAlarm.this.sortColumn, ((AlarmTable)AlarmTable.this).EditorAllNodeAlarm.this.sortDirection);
                    ((AlarmTable)AlarmTable.this).EditorAllNodeAlarm.this.alarmCountText.setBackground(EditorAllNodeAlarm.access$5());
                    ((AlarmTable)AlarmTable.this).EditorAllNodeAlarm.this.refreshButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            if (!EditorAllNodeAlarm.this.isSocket) {
                EditorAllNodeAlarm.this.checkStartButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        EditorAllNodeAlarm.this.checkStartButton.setEnabled(false);
                        EditorAllNodeAlarm.this.startTimer();
                        EditorAllNodeAlarm.this.checkStopButton.setEnabled(true);
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
                EditorAllNodeAlarm.this.checkStopButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        EditorAllNodeAlarm.this.checkStopButton.setEnabled(false);
                        if (EditorAllNodeAlarm.this.timerProcessor != null) {
                            EditorAllNodeAlarm.this.stopTimer();
                        }
                        EditorAllNodeAlarm.this.checkStartButton.setEnabled(true);
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
            }
            this.setTableColumn();
            return this.table;
        }

        private void setTableColumn() {
            this.col0 = new TableColumn(this.table, 0x1000000);
            this.col0.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[0]);
            this.col0.setWidth(EditorAllNodeAlarm.this.computeCol0Width());
            this.col1 = new TableColumn(this.table, 0x1000000);
            this.col1.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[1]);
            this.col1.setWidth(EditorAllNodeAlarm.this.computeCol1Width());
            this.col2 = new TableColumn(this.table, 0x1000000);
            this.col2.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[2]);
            this.col2.setWidth(EditorAllNodeAlarm.this.computeCol2Width());
            this.col3 = new TableColumn(this.table, 0x1000000);
            this.col3.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[3]);
            this.col3.setWidth(EditorAllNodeAlarm.this.computeCol3Width());
            this.col4 = new TableColumn(this.table, 0x1000000);
            this.col4.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[4]);
            this.col4.setWidth(EditorAllNodeAlarm.this.computeCol4Width());
            this.col5 = new TableColumn(this.table, 0x1000000);
            this.col5.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[5]);
            this.col5.setWidth(EditorAllNodeAlarm.this.computeCol5Width());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    AlarmTable.this.setResizedTableColumnWidth();
                }
            });
            this.col0.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol0Direction = AlarmTable.this.sortIntegerTable(AlarmTable.this.table, 0, AlarmTable.this.isCol0Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col1.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol1Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 1, AlarmTable.this.isCol1Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol2Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 2, AlarmTable.this.isCol2Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col3.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol3Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 3, AlarmTable.this.isCol3Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col4.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol4Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 4, AlarmTable.this.isCol4Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col5.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol5Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 5, AlarmTable.this.isCol5Direction, AlarmTable.this.imageColumn);
                }
            });
        }

        protected void setResizedTableColumnWidth() {
            if (EditorAllNodeAlarm.this.getEditorSite().getPage().isPartVisible(EditorAllNodeAlarm.this.getEditorSite().getPart()) && EditorAllNodeAlarm.this.getEditorSite().getShell() != null && EditorAllNodeAlarm.this.getEditorSite().getShell().getSize() != null) {
                this.col0.setWidth(EditorAllNodeAlarm.this.computeCol0Width());
                this.col1.setWidth(EditorAllNodeAlarm.this.computeCol1Width());
                this.col2.setWidth(EditorAllNodeAlarm.this.computeCol2Width());
                this.col3.setWidth(EditorAllNodeAlarm.this.computeCol3Width());
                this.col4.setWidth(EditorAllNodeAlarm.this.computeCol4Width());
                this.col5.setWidth(EditorAllNodeAlarm.this.computeCol5Width());
            }
        }

        public TableItem setTableItem(Table table, TableItem item, String[] strs) {
            Color obj = item.getForeground();
            Image image1 = item.getImage(5);
            item.dispose();
            item = new TableItem(table, 0);
            item.setText(strs);
            item.setData((Object)strs);
            item.setForeground(obj);
            item.setImage(5, image1);
            return item;
        }
    }

    private final class AlarmAction
    extends ActionBuilderAlarmList {
        private AlarmAction() {
        }

        public void refreshNodeAlarmTable() {
            EditorAllNodeAlarm.this.setNodeAlarmeView(EditorAllNodeAlarm.ALARM_ALL, EditorAllNodeAlarm.this.sortColumn, EditorAllNodeAlarm.this.sortDirection);
        }
    }
}

