/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.snmpmanager.process.SnmpManagerCreateSendMessage;
import netjfwatcher.engine.snmpmanager.process.SnmpManagerMessageReceive;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsManager;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;

public abstract class AbstractManagerMessageProcessingSubsystem
extends DataStringDisplay {
    public static final int UNMUCH_REQUEST_ID_RETRY_WAIT_TIME = 3000;
    public static final int MAXSIZE = 8196;
    private static Logger logger;
    protected int snmpPort;
    protected InetAddress targetAddress;
    protected DatagramSocket dSocket;
    protected SnmpV3ManagerConfigInfo snmpV3ManagerConfInfo;
    protected String snmpV3UserName;
    protected int retryCounter;
    protected int retryResourceCounter;
    protected int version;
    protected String community;
    protected SnmpManagerCreateSendMessage messageSendInstance = new SnmpManagerCreateSendMessage();
    protected SnmpManagerMessageReceive messageReceiveInstance = new SnmpManagerMessageReceive();

    public AbstractManagerMessageProcessingSubsystem() {
        logger = Logger.getLogger(this.getClass().getName());
        this.snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
    }

    public abstract void setManagerMP(DatagramSocket var1, InetAddress var2, String var3) throws SnmpConfigurationException, SnmpV3ConfigurationException;

    protected void setConfig(DatagramSocket dSocket, InetAddress hostAddress) throws SnmpConfigurationException, SnmpV3ConfigurationException {
        int socketTimeout = 6000;
        this.retryResourceCounter = 3;
        String socketTimeoutString = "";
        String snmpRetryString = "";
        switch (this.version) {
            case 0: {
                socketTimeoutString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Timeout();
                snmpRetryString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Retry();
                break;
            }
            case 1: {
                socketTimeoutString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV2Timeout();
                snmpRetryString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV2Retry();
                break;
            }
            case 3: {
                socketTimeoutString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV3Timeout();
                snmpRetryString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV3Retry();
                break;
            }
            default: {
                logger.warning("Illegal SNMP Version " + this.version);
            }
        }
        try {
            socketTimeout = Integer.parseInt(socketTimeoutString);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Snmp socket timeout set error at value=" + socketTimeoutString);
            throw new SnmpConfigurationException("Snmp socket timeout set error at value=" + socketTimeoutString);
        }
        try {
            dSocket.setSoTimeout(socketTimeout);
        }
        catch (SocketException e) {
            e.printStackTrace();
            logger.warning("Snmp socket set timeout : " + e.getMessage());
            throw new SnmpConfigurationException("Snmp socket set timeout : " + e.getMessage());
        }
        try {
            this.retryResourceCounter = Integer.parseInt(snmpRetryString);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Socket retry set error. value=" + snmpRetryString);
            throw new SnmpConfigurationException("Socket retry set error. value=" + snmpRetryString);
        }
        if (this.version == 3) {
            this.snmpV3ManagerConfInfo = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(hostAddress.getHostAddress());
            if (this.snmpV3ManagerConfInfo != null) {
                this.snmpV3UserName = ((SnmpV3ManagerUserConfigInfo)this.snmpV3ManagerConfInfo.getUserList().get(0)).getUsername();
                String paddingZero = this.snmpV3ManagerConfInfo.getAsn1BerZeroPadding();
                if (paddingZero.equals("yes") || paddingZero.equals("YES") || paddingZero.equals("Yes")) {
                    AbstractSnmpObject.setZeroPadding(true);
                } else {
                    AbstractSnmpObject.setZeroPadding(false);
                }
            } else {
                logger.warning("Agent not found address : " + hostAddress.getHostAddress());
                throw new SnmpV3ConfigurationException("Agent not found address : " + hostAddress.getHostAddress());
            }
        }
    }

    public abstract SnmpVarBindList getProcess(byte var1, String var2) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpSetException, SnmpV3ConfigurationException, IOException;

    public abstract SnmpVarBindList setProcess(byte var1, String var2, AbstractSnmpObject var3) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpSetException, SnmpV3ConfigurationException, IOException, SnmpBadValueException;

    public abstract SnmpVarBindList getMIBEntry(String var1) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpBadValueException, SnmpMIBGetException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, SnmpErrorStatusException, IOException;

    public abstract SnmpVarBindList getNextMIBEntry(String var1) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpBadValueException, SnmpV3ConfigurationException, IOException;

    public abstract SnmpVarBindList setMIBEntry(String var1, AbstractSnmpObject var2) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpSetException, SnmpMIBGetException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, IOException;

    /*
     * Unable to fully structure code
     */
    protected SnmpVarBindList sendAndReceive(int requestID, String requestOID, byte[] messageEncoding, DatagramSocket dSocket) throws SnmpUnmuchRequestIDException, SnmpErrorStatusException, SnmpMIBGetException, SnmpBadValueException, NoRouteToHostException, SocketTimeoutException, IOException {
        retrievedVars = null;
        this.retryCounter = this.retryResourceCounter;
        while (true) {
            try {
                this.messageReceiveInstance.setSnmpReceiveSocket(this.targetAddress, dSocket);
                this.sendByteDataToAgent(messageEncoding, requestOID, dSocket);
                retrievedVars = this.messageReceiveInstance.parseReceiveData(requestID, requestOID, dSocket);
                socketTimeout = dSocket.getSoTimeout();
                if (AlarmRecovery.getInstance().isOccurredAlarmId(this.targetAddress.getHostAddress(), "4")) {
                    message = AlarmMessageMake.getInstance();
                    message.setRecoverySNMPTimeout(this.targetAddress.getHostAddress(), requestOID, socketTimeout);
                }
                if (AlarmRecovery.getInstance().isOccurredAlarmId(this.targetAddress.getHostAddress(), "5")) {
                    message = AlarmMessageMake.getInstance();
                    message.setRecoverySNMPNoRouteToHost(this.targetAddress.getHostAddress(), requestOID);
                }
                if (!AlarmRecovery.getInstance().isOccurredAlarmId(this.targetAddress.getHostAddress(), "6")) break;
                message = AlarmMessageMake.getInstance();
                message.setRecoverySNMPIOException(this.targetAddress.getHostAddress(), requestOID);
            }
            catch (SnmpUnmuchRequestIDException e1) {
                --this.retryCounter;
                AbstractManagerMessageProcessingSubsystem.logger.info("SnmpUnmuchRequestIDException Retry : " + this.retryCounter);
                if (this.retryCounter <= 0) {
                    message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPUnmuchRequestID(this.targetAddress.getHostAddress(), e1.getMessage());
                    throw e1;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    AbstractManagerMessageProcessingSubsystem.logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                continue;
            }
            catch (NoRouteToHostException e) {
                message = AlarmMessageMake.getInstance();
                message.setErrorSNMPNoRouteToHost(this.targetAddress.getHostAddress(), requestOID);
                AbstractManagerMessageProcessingSubsystem.logger.warning("NoRouteToHostException " + e.getMessage() + " : " + this.targetAddress.getHostAddress() + " : " + requestOID);
                throw new NoRouteToHostException("Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID + " : " + e.getMessage());
            }
            catch (SocketTimeoutException e1) {
                SnmpStatisticsManager.getInstance().addSnmpSocketTimeout(this.targetAddress.getHostAddress());
                --this.retryCounter;
                AbstractManagerMessageProcessingSubsystem.logger.info("Socket Timeout Exception Retry : " + this.retryCounter);
                try {
                    AbstractManagerMessageProcessingSubsystem.logger.info("Timeout : " + dSocket.getSoTimeout());
                }
                catch (SocketException e) {
                    AbstractManagerMessageProcessingSubsystem.logger.warning(String.valueOf(e.getMessage()) + " Socket Timeout Exception Retry : " + this.retryCounter);
                    e.printStackTrace();
                    throw new SnmpMIBGetException(e.getMessage());
                }
                if (this.retryCounter > 0) continue;
                message = AlarmMessageMake.getInstance();
                message.setErrorSNMPTimeout(this.targetAddress.getHostAddress(), requestOID, dSocket.getSoTimeout());
                AbstractManagerMessageProcessingSubsystem.logger.warning(String.valueOf(e1.getMessage()) + " : " + this.targetAddress.getHostAddress() + " : " + requestOID);
                throw new SocketTimeoutException(String.valueOf(e1.getMessage()) + " : IP=" + this.targetAddress.getHostAddress() + " : OID=" + requestOID);
            }
            catch (SnmpBadValueException e) {
                --this.retryCounter;
                AbstractManagerMessageProcessingSubsystem.logger.info("SNMPBadValueException Retry : " + this.retryCounter);
                try {
                    AbstractManagerMessageProcessingSubsystem.logger.info("Timeout : " + dSocket.getSoTimeout());
                }
                catch (SocketException e1) {
                    AbstractManagerMessageProcessingSubsystem.logger.warning(e1.getMessage());
                    e1.printStackTrace();
                    throw new SnmpBadValueException(e1.getMessage());
                }
                if (this.retryCounter <= 0) ** break;
                continue;
                AbstractManagerMessageProcessingSubsystem.logger.warning(String.valueOf(e.getMessage()) + " : " + this.targetAddress.getHostAddress() + " : " + requestOID);
                e.printStackTrace();
                throw new SnmpBadValueException(e.getMessage());
            }
            catch (IOException e2) {
                message = AlarmMessageMake.getInstance();
                message.setErrorSNMPIOException(this.targetAddress.getHostAddress(), requestOID, e2.getMessage());
                AbstractManagerMessageProcessingSubsystem.logger.warning("IOException " + e2.getMessage() + " : " + this.targetAddress.getHostAddress() + " : " + requestOID);
                throw new IOException("Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID + " : " + e2.getMessage());
            }
            break;
        }
        return retrievedVars;
    }

    public void sendByteDataToAgent(byte[] messageEncoding, String requestOID, DatagramSocket sendDSocket) throws NoRouteToHostException, IOException {
        logger.fine("Target IP=" + this.targetAddress.getHostAddress() + " Port=" + this.snmpPort);
        logger.fine("Send data : " + this.hexBytetoString(messageEncoding, messageEncoding.length));
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length);
        sendDSocket.send(outPacket);
    }
}

