/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.http;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;

public class ExecuteHttpCheck {
    private static final boolean IS_SHOW = false;
    private static Logger logger = null;

    public ExecuteHttpCheck() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void getURL(String ipaddress, NodeWatchInfo nodeWatchInfo) {
        String targetURL = nodeWatchInfo.getHttpUrl();
        logger.info("HTTP GET : " + targetURL);
        int httpTimeout = 0;
        try {
            httpTimeout = Integer.parseInt(nodeWatchInfo.getHttpTimeout());
        }
        catch (NumberFormatException e1) {
            logger.warning("Illegal HttpTimeout = " + nodeWatchInfo.getHttpTimeout() + " : " + e1.getMessage());
        }
        try {
            URL accessURL = new URL(targetURL);
            HttpURLConnection urlConn = (HttpURLConnection)accessURL.openConnection();
            urlConn.setConnectTimeout(httpTimeout);
            urlConn.setReadTimeout(httpTimeout);
            urlConn.setRequestMethod("GET");
            urlConn.setInstanceFollowRedirects(false);
            urlConn.setRequestProperty("User-Agent", "NetJFWatcher URLConnect Check");
            urlConn.setRequestProperty("Accept-Language", "ja");
            urlConn.connect();
            if (this.chckResponseCode(ipaddress, urlConn) && AlarmRecovery.getInstance().isOccurredAlarmId(ipaddress, "17")) {
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setRecoveryHTTPGetError(ipaddress, targetURL);
            }
            urlConn.disconnect();
        }
        catch (IllegalArgumentException e) {
            logger.warning("IllegalArgumentException : " + e.getMessage() + " " + targetURL);
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(ipaddress, "IllegalArgumentException : " + e.getMessage() + " " + targetURL);
        }
        catch (SocketTimeoutException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(ipaddress, "SocketTimeoutException : " + e.getMessage() + " (set timeout=" + httpTimeout + "ms)");
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(ipaddress, "UnknownHostException : " + e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(ipaddress, "MalformedURLException : " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(ipaddress, "FileNotFoundException : " + e.getMessage());
        }
        catch (ConnectException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(ipaddress, "ConnectException : " + e.getMessage());
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(ipaddress, "IOException : " + e.getMessage());
        }
        try {
            LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate.getInstance();
            updateLastCheckTime.updateCheckTime(ipaddress);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean chckResponseCode(String ipaddress, HttpURLConnection urlConnecrion) throws SocketTimeoutException, IOException {
        boolean isOk = false;
        InputStream urlInputStream = null;
        InputStreamReader urlInputStreamReader = null;
        BufferedReader bufferdReader = null;
        try {
            int responseCode = urlConnecrion.getResponseCode();
            String responseMessage = urlConnecrion.getResponseMessage();
            if (responseCode != 200) {
                logger.warning("ResponseCode [" + responseCode + "] " + "ResponseMessage [" + responseMessage + "]");
                AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
                makeAlarm.setHTTPGetError(ipaddress, "ResponseCode [" + responseCode + "] " + "ResponseMessage [" + responseMessage + "]");
                Map<String, List<String>> headers = urlConnecrion.getHeaderFields();
                Iterator<String> it = headers.keySet().iterator();
                logger.warning("Response headers:");
                while (it.hasNext()) {
                    String key = it.next();
                    logger.warning("  " + key + ": " + headers.get(key));
                }
                boolean bl = isOk;
                return bl;
            }
            isOk = true;
            if (AlarmRecovery.getInstance().isOccurredAlarmId(ipaddress, "17")) {
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setRecoveryHTTPGetError(ipaddress, "ResponseCode [" + responseCode + "] " + "ResponseMessage [" + responseMessage + "]");
            }
        }
        finally {
            if (bufferdReader != null) {
                try {
                    bufferdReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (urlInputStreamReader != null) {
                try {
                    urlInputStreamReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (urlInputStream != null) {
                try {
                    urlInputStream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
        return isOk;
    }
}

