/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.control.BusyCheckForHttp;
import netjfwatcher.engine.server.protocol.control.QueueForHTTP;
import netjfwatcher.engine.server.protocol.http.ExecuteHttpCheck;

public class ThreadQueueCheckHTTP
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger = null;

    public ThreadQueueCheckHTTP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        ExecuteHttpCheck checkURL = new ExecuteHttpCheck();
        while (!Thread.interrupted()) {
            NodeWatchInfo infoPopQueue = QueueForHTTP.getInstance().popQueue();
            NodeWatchInfo checkIPAddressNodeWatchInfo = null;
            if (infoPopQueue != null) {
                checkIPAddressNodeWatchInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(infoPopQueue.getIpaddress());
            }
            if (infoPopQueue != null && checkIPAddressNodeWatchInfo != null) {
                if (BusyCheckForHttp.getInstance().getArbitrationExec(infoPopQueue.getIpaddress())) {
                    checkURL.getURL(infoPopQueue.getIpaddress(), infoPopQueue);
                    BusyCheckForHttp.getInstance().release(infoPopQueue.getIpaddress());
                } else {
                    logger.warning("Busy HTTP IP = " + infoPopQueue.getIpaddress());
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

