/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.resourceconfig;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class EngineResourceConfigFileParse {
    private static final String ENGINE_TIMEOUT_DEFAULT = "0";
    private static final String CONF_TAG = "conf";
    private static final String ENGINE_TAG = "engine";
    private static final String ENGINE_IPADDRESS_TAG = "ipaddress";
    private static final String ENGINE_PORT_TAG = "port";
    private static final String ENGINE_TIMEOUT_TAG = "timeout";
    private static final String USER_NAME_TAG = "user_name";
    private static final String PASSWORD_TAG = "password";
    private static final String ENGINE_XML_SOCKET_PORT_TAG = "xmlSocketPort";
    private static final String CLIENT_TAG = "client";
    private static final String NODE_REGISTER_PORT_TAG = "xmlSocketReportPort";
    private static final String ATTRIBUTE_VALUE = "value";
    private static Logger logger = null;
    private ArrayList engineInfoList = new ArrayList();
    private String engineIPAddress;
    private String enginePort;
    private String engineTimeout;
    private String userName;
    private String password;
    private String engineFlashXMLSocketPort;
    private String clientXmlSocketPort;

    public EngineResourceConfigFileParse() {
        logger = Logger.getLogger(this.getClass().getName());
        Document doc = null;
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader("resources/engine_resource.xml");
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            if (builder == null) {
                return;
            }
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Element root = doc.getRootElement();
            try {
                List targetList = root.getChildren(ENGINE_TAG);
                int targetCount = 0;
                Iterator iterator0 = targetList.iterator();
                while (iterator0.hasNext()) {
                    try {
                        EngineResourceInfo engineInfo = new EngineResourceInfo();
                        ++targetCount;
                        Element targetListEl = (Element)iterator0.next();
                        this.engineIPAddress = targetListEl.getChild(ENGINE_IPADDRESS_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEngineIPaddress(this.engineIPAddress);
                        this.enginePort = targetListEl.getChild(ENGINE_PORT_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEnginePort(this.enginePort);
                        if (targetListEl.getChild(ENGINE_TIMEOUT_TAG) != null) {
                            this.engineTimeout = targetListEl.getChild(ENGINE_TIMEOUT_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                            engineInfo.setEngineTimeout(this.engineTimeout);
                        } else {
                            engineInfo.setEngineTimeout(ENGINE_TIMEOUT_DEFAULT);
                        }
                        if (targetListEl.getChild(USER_NAME_TAG) != null) {
                            this.userName = targetListEl.getChild(USER_NAME_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                            engineInfo.setUserName(this.userName);
                        } else {
                            engineInfo.setUserName("admin");
                        }
                        if (targetListEl.getChild(PASSWORD_TAG) != null) {
                            this.password = targetListEl.getChild(PASSWORD_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                            engineInfo.setPassword(this.password);
                        } else {
                            engineInfo.setPassword("admin");
                        }
                        this.engineFlashXMLSocketPort = targetListEl.getChild(ENGINE_XML_SOCKET_PORT_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEngineFlashXMLSocketPort(this.engineFlashXMLSocketPort);
                        this.engineInfoList.add(engineInfo);
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                        logger.warning("Abort Engine XML File parse at target No." + targetCount);
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            Element clientEl = root.getChild(CLIENT_TAG);
            this.clientXmlSocketPort = clientEl.getChild(NODE_REGISTER_PORT_TAG).getAttributeValue(ATTRIBUTE_VALUE);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void updateEngineResource(ArrayList engineInfoList, String xmlSocketReportPort) {
        Document dom = this.updateDocument(engineInfoList, xmlSocketReportPort);
        BufferedWriter bufWriter = this.getResourceFileWriter();
        if (dom != null && bufWriter != null) {
            this.outputXMLFile(bufWriter, dom);
        }
    }

    private Document updateDocument(ArrayList engineInfoList, String xmlSocketReportPort) {
        Element confElement = new Element(CONF_TAG);
        Document doc = new Document(confElement);
        if (engineInfoList == null) {
            return null;
        }
        confElement.addContent((Content)new Comment("Engine Communication Information"));
        EngineResourceInfo engineInfo = null;
        int i = 0;
        while (engineInfoList.size() > i) {
            engineInfo = (EngineResourceInfo)engineInfoList.get(i);
            if (engineInfo == null) {
                logger.warning("Not found SNMP Config at index=" + i);
                break;
            }
            Element engineEl = new Element(ENGINE_TAG);
            confElement.addContent((Content)engineEl);
            Element ipAddressEl = new Element(ENGINE_IPADDRESS_TAG);
            engineEl.addContent((Content)ipAddressEl);
            Element enginePortEl = new Element(ENGINE_PORT_TAG);
            engineEl.addContent((Content)enginePortEl);
            Element engineTimeoutEl = new Element(ENGINE_TIMEOUT_TAG);
            engineEl.addContent((Content)engineTimeoutEl);
            Element userNameEl = new Element(USER_NAME_TAG);
            engineEl.addContent((Content)userNameEl);
            Element passwordEl = new Element(PASSWORD_TAG);
            engineEl.addContent((Content)passwordEl);
            Element xmlSocketPortEl = new Element(ENGINE_XML_SOCKET_PORT_TAG);
            engineEl.addContent((Content)xmlSocketPortEl);
            ipAddressEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, engineInfo.getEngineIPaddress()));
            enginePortEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, engineInfo.getEnginePort()));
            if (engineInfo.getEngineTimeout() != null) {
                engineTimeoutEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, engineInfo.getEngineTimeout()));
            }
            userNameEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, engineInfo.getUserName()));
            passwordEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, engineInfo.getPassword()));
            xmlSocketPortEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, engineInfo.getEngineFlashXMLSocketPort()));
            ++i;
        }
        Element clientEl = new Element(CLIENT_TAG);
        clientEl.addContent((Content)new Comment("Node Register Status Report Port"));
        confElement.addContent((Content)clientEl);
        Element xmlSocketReportPortEl = new Element(NODE_REGISTER_PORT_TAG);
        clientEl.addContent((Content)xmlSocketReportPortEl);
        if (xmlSocketReportPort != null) {
            xmlSocketReportPortEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, xmlSocketReportPort));
        }
        return doc;
    }

    private BufferedWriter getResourceFileWriter() {
        File f = new File("resources/engine_resource.xml");
        logger.info("Path : " + f.getAbsolutePath());
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("resources/engine_resource.xml");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public String getEngineIPAddress() {
        return this.engineIPAddress;
    }

    public String getClientXmlSocketPort() {
        return this.clientXmlSocketPort;
    }

    public ArrayList getEngineInfoList() {
        return this.engineInfoList;
    }

    private void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        XMLOutputter outputter = XMLOutputterFormat.getInstance().getXMLOutputterFormat();
        OutputStreamWriter writer = null;
        try {
            try {
                outputter.output(dom, (OutputStream)System.out);
                outputter.output(dom, (Writer)bufWriter);
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}

