/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.DatabasePropertyInfoList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public final class DatabasePropertyResource {
    public static final String DATABASE = "database";
    public static final String DATABASE_NAME = "database_name";
    public static final String DATABASE_DRIVER = "driver";
    public static final String DATABASE_URL = "url";
    public static final String DATABASE_USER = "user";
    public static final String DATABASE_PASSWORD = "password";
    private static Logger logger;
    private DatabasePropertyInfoList databasepropList;

    private DatabasePropertyResource() {
        logger = Logger.getLogger(this.getClass().getName());
        Document doc = null;
        doc = this.getResourceFileDocumentPath("resources/database_property.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        try {
            Element root = doc.getRootElement();
            this.databasepropList = new DatabasePropertyInfoList();
            List mailList = root.getChildren(DATABASE);
            Iterator iterator = mailList.iterator();
            while (iterator.hasNext()) {
                DatabasePropertyInfo databaseProp = new DatabasePropertyInfo();
                Element mailListEl = (Element)iterator.next();
                databaseProp.setDatabaseName(mailListEl.getChild(DATABASE_NAME).getAttributeValue("value"));
                databaseProp.setDatabaseDriver(mailListEl.getChild(DATABASE_DRIVER).getAttributeValue("value"));
                databaseProp.setDatabaseUrl(mailListEl.getChild(DATABASE_URL).getAttributeValue("value"));
                databaseProp.setDatabaseUser(mailListEl.getChild(DATABASE_USER).getAttributeValue("value"));
                databaseProp.setDatabasePassword(mailListEl.getChild(DATABASE_PASSWORD).getAttributeValue("value"));
                this.databasepropList.setDatabasePropList(databaseProp);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public DatabasePropertyInfoList getdatabasePropList() {
        return this.databasepropList;
    }

    public String getDocumentPath() {
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry("resources/database_property.xml");
        if (url == null) {
            logger.severe("URL Not Found : resources/database_property.xml");
            logger.severe("Database XML file url : " + url);
            return null;
        }
        return url.getPath();
    }

    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;
        File f = new File(file);
        logger.info("Path : " + f.getAbsolutePath());
        if (f == null) {
            return null;
        }
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static DatabasePropertyResource getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ DatabasePropertyResource(DatabasePropertyResource databasePropertyResource) {
        this();
    }

    private static class SingletonResource {
        static final DatabasePropertyResource RESOURCE = new DatabasePropertyResource(null);

        private SingletonResource() {
        }
    }
}

