/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.util.logging.Logger;
import netjfwatcher.engine.preferance.AbstractEnginePreferancePage;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UnregistrationNodePreference
extends AbstractEnginePreferancePage
implements IWorkbenchPreferencePage {
    public static final String VALID = "valid";
    public static final String IGNORE = "ignore";
    private static Logger logger;
    private ResourceInfo resourceInfo;
    private Button unregistrationNodeAlarmCheckButton;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected Control createContents(Composite parent) {
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        new GridData();
        this.unregistrationNodeAlarmCheckButton = new Button(composite, 32);
        this.unregistrationNodeAlarmCheckButton.setText("Effective Unregistration Node Alarm.");
        this.unregistrationNodeAlarmCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Button bChk = (Button)event.widget;
                if (bChk.getSelection()) {
                    UnregistrationNodePreference.this.resourceInfo.setUnregistrationNodeAlarm(UnregistrationNodePreference.VALID);
                } else {
                    UnregistrationNodePreference.this.resourceInfo.setUnregistrationNodeAlarm(UnregistrationNodePreference.IGNORE);
                }
            }
        });
        this.setUnregistrationNodeAlarmCheckButton();
        return composite;
    }

    private void setUnregistrationNodeAlarmCheckButton() {
        if (this.resourceInfo.getUnregistrationNodeAlarm().equals(IGNORE)) {
            this.unregistrationNodeAlarmCheckButton.setSelection(false);
        } else {
            this.unregistrationNodeAlarmCheckButton.setSelection(true);
        }
    }

    protected void performDefaults() {
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
    }

    public boolean performOk() {
        this.saveResourceXMLInfo(this.resourceInfo);
        return super.performOk();
    }
}

