/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpPrintMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public class CommandGetNodeSnmp
extends TemplateCommandImpl {
    private static Logger logger;

    public void doInvoke(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());
        NodeInformation nodeInfo = null;
        DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
        try {
            try {
                ArrayList list = nodeRegisterDBTable.findTarget(com.getIpaddress());
                if (list.size() > 0) {
                    nodeInfo = (NodeInformation)list.get(0);
                }
            }
            catch (SQLException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
            catch (Exception e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            nodeRegisterDBTable = null;
        }
        String snmpVersion = nodeInfo.getSnmpVersion();
        int version = 0;
        if (snmpVersion.equals("SNMPV1")) {
            version = 0;
        } else if (snmpVersion.equals("SNMPV2C")) {
            version = 1;
        } else if (snmpVersion.equals("SNMPV3")) {
            version = 3;
        } else {
            logger.warning("Bad snmp version : " + snmpVersion);
        }
        SnmpSystemMibGet systemMib = null;
        SnmpInterfacesMibGet mibInterfacesGet = null;
        try {
            systemMib = new SnmpSystemMibGet();
            systemMib.setSnmpSystemMibGet(nodeInfo.getIpaddress(), version, nodeInfo.getRoCommunity());
            systemMib.getSystemMIB();
            mibInterfacesGet = new SnmpInterfacesMibGet();
            mibInterfacesGet.setSnmpInterfacesMibGet(nodeInfo.getIpaddress(), version, nodeInfo.getRoCommunity());
            mibInterfacesGet.getInterfacesMIB();
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SocketException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (SnmpMIBGetException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        if (nodeInfo.getNodeKind().equals("Printer")) {
            SnmpPrintMibGet printMibGetInstance = new SnmpPrintMibGet();
            printMibGetInstance.setSnmpPrintMibGet(nodeInfo.getIpaddress(), version, nodeInfo.getRoCommunity());
            try {
                printMibGetInstance.getPrintMIB();
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        this.sendResponse(nodeInfo, ois, oos);
    }
}

