/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.engine.socket.info.PingInfo;
import netjfwatcher.engine.socket.info.PingProperty;

public final class DBTablePingResponse
extends DBTableBase {
    public static final String PING_RESPONSE_TABLE_NAME = "_pingresponse";
    public static final String CURDATE = "curdate";
    public static final String DIFF_TIME = "difftime";
    private static Logger logger = null;
    private DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTablePingResponse() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static DBTablePingResponse getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void createTable(String paraIPAddress) throws DatabaseConnectionException, SQLException {
        String targetIpAddress = "IP" + paraIPAddress.replace('.', '_');
        targetIpAddress = targetIpAddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccess = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            String autoIncrement = dataaccess.getAutoIncrement();
            String pingTableItem = " (" + autoIncrement + "," + CURDATE + " " + "TIMESTAMP" + "," + DIFF_TIME + " " + "BIGINT" + ")";
            this.deleteTable(databaseAccess, String.valueOf(targetIpAddress) + PING_RESPONSE_TABLE_NAME);
            if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Postgresql")) {
                this.dropSequence(databaseAccess, "DROP SEQUENCE " + targetIpAddress + "_ping_id_seq");
                pingTableItem = " (id INTEGER DEFAULT NEXTVAL('" + targetIpAddress + "_ping_id_seq'" + "), curdate TIMESTAMP," + DIFF_TIME + " BIGINT)";
                databaseAccess.executeUpdate("CREATE SEQUENCE " + targetIpAddress + "_ping_id_seq");
            }
            databaseAccess.executeUpdate("CREATE TABLE " + targetIpAddress + PING_RESPONSE_TABLE_NAME + pingTableItem);
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(paraIPAddress, String.valueOf(targetIpAddress) + PING_RESPONSE_TABLE_NAME, "yes");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable(String paraIPAddress) throws DatabaseConnectionException, SQLException {
        String targetIpAddress = "IP" + paraIPAddress.replace('.', '_');
        targetIpAddress = targetIpAddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            databaseAccess.executeUpdate("DROP TABLE IF EXISTS " + targetIpAddress + PING_RESPONSE_TABLE_NAME);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void putPingTable(String paraIPAddress, long difftime) throws DatabaseConnectionException, SQLException {
        String targetIpAddress = "IP" + paraIPAddress.replace('.', '_');
        targetIpAddress = targetIpAddress.replace('-', '_');
        Date date = Calendar.getInstance().getTime();
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            databaseAccess.executeUpdate("insert into " + targetIpAddress + PING_RESPONSE_TABLE_NAME + "( " + CURDATE + ", " + DIFF_TIME + " )" + " VALUES( '" + this.simpleDateformat.format(date) + "'," + difftime + ")");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public synchronized ArrayList findAll(String ipaddress, String startTime, String endTime) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<PingInfo> list = null;
        list = new ArrayList<PingInfo>();
        try {
            String convIPAddress = "IP" + ipaddress.replace('.', '_');
            convIPAddress = convIPAddress.replace('-', '_');
            String sql = "";
            sql = startTime == null || endTime == null ? "SELECT * from " + convIPAddress + PING_RESPONSE_TABLE_NAME + " order by " + CURDATE + " desc" : "SELECT * from " + convIPAddress + PING_RESPONSE_TABLE_NAME + " where " + CURDATE + " between " + "'" + startTime + "'" + " and " + "'" + endTime + "'" + " order by " + CURDATE + " desc";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                PingInfo info = new PingInfo();
                if (rs.getObject(DIFF_TIME) != null) {
                    info.setPingDiffTime(Long.parseLong(rs.getObject(DIFF_TIME).toString()));
                }
                if (rs.getObject(CURDATE) != null) {
                    info.setPingCheckDate((Date)rs.getObject(CURDATE));
                }
                list.add(info);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return list;
    }

    public synchronized PingProperty getDataCount(String ipaddress) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        PingProperty pingProperty = new PingProperty();
        try {
            String convIPAddress = "IP" + ipaddress.replace('.', '_');
            convIPAddress = convIPAddress.replace('-', '_');
            String sql = "select count(*) from " + convIPAddress + PING_RESPONSE_TABLE_NAME;
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            int count = -1;
            count = rs.getInt(1);
            pingProperty.setTotalDataCount(count);
            sql = "select min(difftime), max(difftime) from " + convIPAddress + PING_RESPONSE_TABLE_NAME;
            rs = stmt.executeQuery(sql);
            rs.next();
            long minDiffTime = -1L;
            minDiffTime = rs.getLong(1);
            long maxDiffTime = -1L;
            maxDiffTime = rs.getLong(2);
            pingProperty.setMinData(Long.toString(minDiffTime));
            pingProperty.setMaxData(Long.toString(maxDiffTime));
            sql = "select min(curdate), max(curdate) from " + convIPAddress + PING_RESPONSE_TABLE_NAME;
            rs = stmt.executeQuery(sql);
            rs.next();
            pingProperty.setStartDate((Date)rs.getObject(1));
            pingProperty.setEndDate((Date)rs.getObject(2));
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return pingProperty;
    }

    /* synthetic */ DBTablePingResponse(DBTablePingResponse dBTablePingResponse) {
        this();
    }

    private static class SingletonResource {
        static final DBTablePingResponse RESOURCE = new DBTablePingResponse(null);

        private SingletonResource() {
        }
    }
}

