/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;

public final class DBTableDatabaseWatcher
extends DBTableBase {
    public static final String DATABASE_WATCHER_TABLE_NAME = "database_watcher";
    public static final String IPADDRESS = "ipAddress";
    public static final String USERNAME = "userName";
    public static final String PASSWORD = "password";
    public static final String JDBC_DRIVER = "jdbcDriver";
    public static final String DATABASE_NAME = "databaseName";
    public static final String CONNECT_URL = "connectURL";
    public static final String WATCHER_PERIOD = "watcherPeriod";
    public static final String DATABASE_SQL = "checkSql";
    public static final String ISQUERY = "isQuery";
    public static final String DATABASE_EXPECT = "expect";
    public static final String CURDATE = "curdate";
    public static final String QUERY_STRING = "Query";
    public static final String UPDATE_STRING = "Update";
    private static Logger logger = null;
    private static final String DATABASE_WATCH_TABLE_ITEM = " (userName VARCHAR(255), password  VARCHAR(255),jdbcDriver VARCHAR(255),databaseName VARCHAR(255),connectURL VARCHAR(255),ipAddress VARCHAR(255),watcherPeriod VARCHAR(255),checkSql VARCHAR(255),isQuery VARCHAR(255),expect VARCHAR(255),curdate TIMESTAMP )";
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableDatabaseWatcher() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, DATABASE_WATCHER_TABLE_NAME);
            databaseAccess.executeUpdate("CREATE TABLE database_watcher (userName VARCHAR(255), password  VARCHAR(255),jdbcDriver VARCHAR(255),databaseName VARCHAR(255),connectURL VARCHAR(255),ipAddress VARCHAR(255),watcherPeriod VARCHAR(255),checkSql VARCHAR(255),isQuery VARCHAR(255),expect VARCHAR(255),curdate TIMESTAMP )");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, DATABASE_WATCHER_TABLE_NAME);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized DatabaseWatcherInfo findDatabaseWatcher(String tragetIpAddress) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        DatabaseWatcherInfo databaseInfo = null;
        try {
            String sql = "SELECT * from database_watcher where ipAddress='" + tragetIpAddress + "'";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                databaseInfo = new DatabaseWatcherInfo();
                databaseInfo.setDatabaseUser(rs.getObject(USERNAME).toString());
                databaseInfo.setDatabasePassword(rs.getObject(PASSWORD).toString());
                databaseInfo.setDatabaseDriver(rs.getObject(JDBC_DRIVER).toString());
                databaseInfo.setDatabaseName(rs.getObject(DATABASE_NAME).toString());
                databaseInfo.setDatabaseUrl(rs.getObject(CONNECT_URL).toString());
                databaseInfo.setWatcherPeriod(rs.getObject(WATCHER_PERIOD).toString());
                databaseInfo.setDatabaseSQL(rs.getObject(DATABASE_SQL).toString());
                String isQuery = rs.getObject(ISQUERY).toString();
                if (isQuery.equals(QUERY_STRING)) {
                    databaseInfo.setQuery(true);
                } else {
                    databaseInfo.setQuery(false);
                }
                databaseInfo.setDatabaseExpect(rs.getObject(DATABASE_EXPECT).toString());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
        return databaseInfo;
    }

    public synchronized void putDatabaseWatcher(String tragetIpAddress, DatabaseWatcherInfo databaseInfo) throws DatabaseConnectionException, SQLException {
        String isQuery = databaseInfo.isQuery() ? QUERY_STRING : UPDATE_STRING;
        Date date = Calendar.getInstance().getTime();
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        String sql = "";
        try {
            try {
                if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                    sql = "insert into database_watcher( ipAddress, userName, password, jdbcDriver, databaseName, connectURL, watcherPeriod, checkSql, isQuery, expect, curdate ) VALUES( '" + tragetIpAddress + "'," + "'" + databaseInfo.getDatabaseUser() + "'," + "'" + databaseInfo.getDatabasePassword() + "'," + "'" + databaseInfo.getDatabaseDriver() + "'," + "'" + databaseInfo.getDatabaseName() + "'," + "'" + databaseInfo.getDatabaseUrl() + "'," + "'" + databaseInfo.getWatcherPeriod() + "'," + "'" + databaseInfo.getDatabaseSQL() + "'," + "'" + isQuery + "'," + "'" + databaseInfo.getDatabaseExpect() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                } else {
                    sql = "insert into database_watcher( ipAddress, userName, password, jdbcDriver, databaseName, connectURL, watcherPeriod, checkSql, isQuery, expect, curdate ) VALUES( '" + tragetIpAddress + "'," + "'" + databaseInfo.getDatabaseUser() + "'," + "'" + databaseInfo.getDatabasePassword() + "'," + "'" + databaseInfo.getDatabaseDriver() + "'," + "'" + databaseInfo.getDatabaseName() + "'," + "'" + databaseInfo.getDatabaseUrl() + "'," + "'" + databaseInfo.getWatcherPeriod() + "'," + "'" + databaseInfo.getDatabaseSQL() + "'," + "'" + isQuery + "'," + "'" + databaseInfo.getDatabaseExpect() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                }
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress + " SQL=" + sql);
                throw ex;
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress + " SQL=" + sql);
                throw e;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void updateDatabaseWatcher(String tragetIpAddress, DatabaseWatcherInfo databaseInfo) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                this.updateDatabaseWatcherTabel(databaseAccess, tragetIpAddress, databaseInfo);
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress);
                ex.printStackTrace();
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    private void updateDatabaseWatcherTabel(DatabaseAccess databaseAccess, String tragetIpAddress, DatabaseWatcherInfo databaseInfo) throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();
        String isQuery = databaseInfo.isQuery() ? QUERY_STRING : UPDATE_STRING;
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
            databaseAccess.executeUpdate("UPDATE database_watcher set ipAddress='" + tragetIpAddress + "', " + USERNAME + "='" + databaseInfo.getDatabaseUser() + "', " + PASSWORD + "='" + databaseInfo.getDatabasePassword() + "', " + JDBC_DRIVER + "='" + databaseInfo.getDatabaseDriver() + "', " + DATABASE_NAME + "='" + databaseInfo.getDatabaseName() + "', " + CONNECT_URL + "='" + databaseInfo.getDatabaseUrl() + "', " + WATCHER_PERIOD + "='" + databaseInfo.getWatcherPeriod() + "', " + DATABASE_SQL + "='" + databaseInfo.getDatabaseSQL() + "', " + ISQUERY + "='" + isQuery + "', " + DATABASE_EXPECT + "='" + databaseInfo.getDatabaseExpect() + "', " + CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'" + " ");
        } else {
            databaseAccess.executeUpdate("UPDATE database_watcher set ipAddress='" + tragetIpAddress + "', " + USERNAME + "='" + databaseInfo.getDatabaseUser() + "', " + PASSWORD + "='" + databaseInfo.getDatabasePassword() + "', " + JDBC_DRIVER + "='" + databaseInfo.getDatabaseDriver() + "', " + DATABASE_NAME + "='" + databaseInfo.getDatabaseName() + "', " + CONNECT_URL + "='" + databaseInfo.getDatabaseUrl() + "', " + WATCHER_PERIOD + "='" + databaseInfo.getWatcherPeriod() + "', " + DATABASE_SQL + "='" + databaseInfo.getDatabaseSQL() + "', " + ISQUERY + "='" + isQuery + "', " + DATABASE_EXPECT + "='" + databaseInfo.getDatabaseExpect() + "', " + CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'" + " ");
        }
    }

    public synchronized void deleteDatabaseWatcherNodeIP(String tragetIpAddress) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "";
            sql = "DELETE from database_watcher where ipAddress='" + tragetIpAddress + "'";
            databaseAccess.executeUpdate(sql);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public static DBTableDatabaseWatcher getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ DBTableDatabaseWatcher(DBTableDatabaseWatcher dBTableDatabaseWatcher) {
        this();
    }

    private static class SingletonResource {
        static final DBTableDatabaseWatcher RESOURCE = new DBTableDatabaseWatcher(null);

        private SingletonResource() {
        }
    }
}

