/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;

public class ApacheDerbyDatabaseInit {
    public static final String DERBY_ATTRIBUTES = "create=true;";
    private static Logger logger = null;

    public void createDatabase() throws IllegalAccessException, InstantiationException, ClassNotFoundException, SQLException {
        logger = Logger.getLogger(this.getClass().getName());
        AbstractDataAccessObject databaseProp = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        String jdbcdriver = databaseProp.getDriver();
        String url = String.valueOf(databaseProp.getDatabaseurl()) + "nodewatch" + ";" + DERBY_ATTRIBUTES;
        String username = databaseProp.getUser();
        String password = databaseProp.getPassword();
        Statement stmt = null;
        Connection con = null;
        try {
            try {
                Class.forName(jdbcdriver).newInstance();
                con = DriverManager.getConnection(url, username, password);
                stmt = con.createStatement();
                logger.info("Database Kind : " + DatabaseAccessControlKind.getInstance().getDatabaseName());
                stmt.executeUpdate("CREATE TABLE database_test (id INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY , test_char VARCHAR(15),test_date TIMESTAMP)");
                stmt.executeUpdate("DROP TABLE database_test");
            }
            catch (IllegalAccessException e) {
                logger.severe("IllegalAccessException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
            catch (InstantiationException e) {
                logger.severe("InstantiationException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
            catch (ClassNotFoundException e) {
                logger.severe("ClassNotFoundException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
            catch (SQLException e) {
                logger.warning("URL = " + url + " : User = " + username + " : Password = " + password);
                logger.severe(e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }
}

