/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.control;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.model.action.DatabaseControl;

public final class DatabaseConnectionPool {
    private static final int MAXCONNECTION = 10;
    private static final int WAIT_TIME = 100;
    private static Logger logger = null;
    private final List<Connection> connectionsListPool = Collections.synchronizedList(new LinkedList());
    private String jdbcdriver;
    private String url;
    private String username;
    private String password;

    private DatabaseConnectionPool() {
        logger = Logger.getLogger(this.getClass().getName());
        this.createConnectionPool();
    }

    public void createConnectionPool() {
        this.connectionsListPool.clear();
        AbstractDataAccessObject dataaccessObject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        this.jdbcdriver = dataaccessObject.getDriver();
        this.url = dataaccessObject.getUrl();
        this.username = dataaccessObject.getUser();
        this.password = dataaccessObject.getPassword();
        try {
            Class.forName(this.jdbcdriver).newInstance();
            int i = 0;
            while (i < 10) {
                Connection con = DriverManager.getConnection(this.url, this.username, this.password);
                this.connectionsListPool.add(con);
                ++i;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            logger.severe("InstantiationException " + e.getMessage() + " url=" + this.url + " username=" + this.username + " password=" + this.password);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            logger.severe("IllegalAccessException " + e.getMessage() + " url=" + this.url + " username=" + this.username + " password=" + this.password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            logger.severe("ClassNotFoundException " + e.getMessage() + " url=" + this.url + " username=" + this.username + " password=" + this.password);
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.severe("SQLException " + e.getMessage() + " url=" + this.url + " username=" + this.username + " password=" + this.password);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe("Exception " + e.getMessage() + " url=" + this.url + " username=" + this.username + " password=" + this.password);
        }
    }

    public synchronized Connection getConnection(int count) throws DatabaseConnectionException {
        if (count < 1) {
            logger.warning("Database connection pool is nothing. jdbcdriver=" + this.jdbcdriver + " url=" + this.url + " username=" + this.username + " password=" + this.password);
            return null;
        }
        if (this.connectionsListPool.size() > 0) {
            Connection conn = this.connectionsListPool.get(0);
            this.connectionsListPool.remove(0);
            return conn;
        }
        try {
            if (!DatabaseControl.getInstance().isDatabaseStart()) {
                logger.warning("Inactive Database : " + DatabaseAccessControlKind.getInstance().getDatabaseName());
                throw new DatabaseConnectionException("Inactive Database : " + DatabaseAccessControlKind.getInstance().getDatabaseName());
            }
            logger.info("Database connection wait");
            this.wait(100L);
        }
        catch (InterruptedException e) {
            logger.warning(e.getMessage());
            throw new DatabaseConnectionException(e.getMessage());
        }
        return this.getConnection(count - 1);
    }

    public synchronized void releaseConnection(Connection conn) {
        this.connectionsListPool.add(conn);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        int i = 0;
        while (i < this.connectionsListPool.size()) {
            Connection conn = this.connectionsListPool.get(i);
            conn.close();
            ++i;
        }
    }

    public static DatabaseConnectionPool getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /* synthetic */ DatabaseConnectionPool(DatabaseConnectionPool databaseConnectionPool) {
        this();
    }

    private static class SingletonAboutMessage {
        static final DatabaseConnectionPool DBPOOL = new DatabaseConnectionPool(null);

        private SingletonAboutMessage() {
        }
    }
}

