/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.application;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderPerspective {
    private IAction netwaokAction = new ActionNetworkWatch();
    private IAction snmpBrowserAction = new ActionSNMPBrowser();
    private IAction snmpAgentAction = new ActionSNMPAgent();
    private IAction nodeManagerAgentAction = new ActionNodeManager();
    private IAction socketClientAction = new ActionSocketClient();
    private static Logger logger;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderPerspective() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionNetworkWatch() {
        return this.netwaokAction;
    }

    public IAction getActionSnmpBrowser() {
        return this.snmpBrowserAction;
    }

    public IAction getActionSnmpAgent() {
        return this.snmpAgentAction;
    }

    public IAction getActionNodeManager() {
        return this.nodeManagerAgentAction;
    }

    public IAction getActionSocketClient() {
        return this.socketClientAction;
    }

    private abstract class AbstractPerspectiveAction
    extends Action {
        private AbstractPerspectiveAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    protected class ActionNetworkWatch
    extends AbstractPerspectiveAction {
        protected ActionNetworkWatch() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderPerspective.this.bundle.getEntry("icons/engine.gif"));
        }

        public String getText() {
            return "Network Watcher Start";
        }

        public String getToolTipText() {
            return "Network Watcher Start";
        }

        protected void doTask() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.showPerspective("netjfwatcher.engine.view.EngineManagerPerspective", workbench.getActiveWorkbenchWindow());
                workbench.showPerspective("netjfwatcher.engine.nodemaneger.NodeManagerPerspective", workbench.getActiveWorkbenchWindow());
                ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();
                actionBuilderEngine.getActionStartEngine().run();
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort system start.");
                logger.warning("Abort system start. " + e.getMessage());
                shell.dispose();
            }
        }
    }

    public class ActionSNMPBrowser
    extends AbstractPerspectiveAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderPerspective.this.bundle.getEntry("icons/SnmpM.gif"));
        }

        public String getText() {
            return "SNMP Browser open";
        }

        public String getToolTipText() {
            return "SNMP Browser open";
        }

        protected void doTask() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.openWorkbenchWindow("SNMPManager", null);
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort SNMP Browser start.");
                logger.warning("Abort SNMP Browser start. " + e.getMessage());
                shell.dispose();
            }
        }
    }

    public class ActionSNMPAgent
    extends AbstractPerspectiveAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderPerspective.this.bundle.getEntry("icons/SnmpA.gif"));
        }

        public String getText() {
            return "SNMP Agent open";
        }

        public String getToolTipText() {
            return "SNMP Agent open";
        }

        protected void doTask() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.openWorkbenchWindow("netjfwatcher.snmpagent.AgentPerspective", null);
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort SNMP Browser start.");
                logger.warning("Abort SNMP Browser start. " + e.getMessage());
                shell.dispose();
            }
        }
    }

    protected class ActionNodeManager
    extends AbstractPerspectiveAction {
        protected ActionNodeManager() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderPerspective.this.bundle.getEntry("icons/manager.gif"));
        }

        public String getText() {
            return "Show Node manger";
        }

        public String getToolTipText() {
            return "Show Node manger";
        }

        protected void doTask() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.showPerspective("netjfwatcher.engine.nodemaneger.NodeManagerPerspective", workbench.getActiveWorkbenchWindow());
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort show Node Manager.");
                logger.warning("Abort show Node Manager. " + e.getMessage());
                shell.dispose();
            }
        }
    }

    protected class ActionSocketClient
    extends AbstractPerspectiveAction {
        protected ActionSocketClient() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderPerspective.this.bundle.getEntry("icons/monitor_obj.gif"));
        }

        public String getText() {
            return "Show Node manger at Socket client";
        }

        public String getToolTipText() {
            return "Show Node manger at Socket client";
        }

        protected void doTask() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.showPerspective("netjfwatcher.socketclient.NetworkClientPerspective", workbench.getActiveWorkbenchWindow());
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort show socket client.");
                logger.warning("Abort show socket client. " + e.getMessage());
                shell.dispose();
            }
        }
    }
}

