/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.networkcamera.gui;

import java.util.logging.Logger;

import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.model.action.ListenerNodeListTree;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarm;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionShowNodeView;
import netjfwatcher.engine.nodecontrol.NodeKind;
import netjfwatcher.engine.nodemaneger.list.NodeListTreeView;
import netjfwatcher.engine.socket.info.NodeInformation;
import netwatcherrcpnetworkcamera.actions.ActionBuilderNetworkCamera;
import netwatcherrcpnetworkcamera.actions.ActionBuilderNetworkCamera.ActionNetworkCamera;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;


public class NetworkCameratTreeView extends NodeListTreeView {
    /* MO */
    private static Logger logger = null;

    /* Network Camera m[h֘ÃANV */
    private ActionBuilderNetworkCamera networkCameraAction = new ActionBuilderNetworkCamera();
    /**
     * m[hTree\ViewNXCX^X𐶐܂B
     *
     */
    public NetworkCameratTreeView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[Xm[hĎ񃊃XgǂݍTree\
     * ܂B
     *
     */
    protected void initShow() {
        /* ((ActionReloadNodeTreeDatabase) actionNodeTree.
         * actionReloadNodeTreeDatabase()).setNodeTree();
        */
    }

    /**
     * ReLXgj[𐶐܂B
     *
     */
    public void createContextMenu() {
        /* j[}l[W */
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);

        /* j[Xi[Zbg */
        mm.addMenuListener(
            new IMenuListener() {
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        Menu menu = mm.createContextMenu(nodeListTreeViewer.getControl());
        nodeListTreeViewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, nodeListTreeViewer);
    }



    /**
     * j[o[ݒ肵܂B
     * preWindowOpenɌĂ΂܂B
     * m[hTreẽm[hIĂꍇƑIĂȂꍇ
     * j[ς܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        /* m[hTreeǂݍ݃ANVZbg */
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

        /* m[hTreeēǂݍ */
        manager.add(getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());

        /* m[hTree\[g */
        manager.add(getActionNodeTreeBuilder().actionSortNodeTreeDatabase());

        /*
         * Treẽm[hIĂ邩`FbN
         */
        if (nodeListTreeViewer.getTree().getSelection() != null) {
            TreeItem[] treeItem = nodeListTreeViewer.getTree().getSelection();

            if ((treeItem != null) && (treeItem.length > 0)) {
                for (
                    int nodeTreeSelectNo = 0;
                        nodeTreeSelectNo < treeItem.length;
                        nodeTreeSelectNo++) {
                    if (
                        treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
                        /* GroupI */
                        nodeListTreeViewer.getTree().deselectAll();
                    } else if (
                        treeItem[nodeTreeSelectNo].getData() instanceof NodeTree) {
                        NodeInformation targetNodeInfo =
                            ((NodeTree) treeItem[nodeTreeSelectNo].getData())
                            .getNodeInfo();

                        /* m[h\`j[ǉ */
                        ((ActionShowNodeView) actionBuilderNodeOperation
                        .getActionShowNodeView()).setNodeInfo(targetNodeInfo);
                        manager.add(
                            actionBuilderNodeOperation.getActionShowNodeView());

                        /* m[hAlarmj[ǉ */
                        ((ActionOpenEditorPartPersonalNodeAlarm) actinAlarm
                        .getActionOpenEditorPartPersonalNodeAlarm())
                        .setNodeInfo(targetNodeInfo);
                        manager.add(
                            actinAlarm.getActionOpenEditorPartPersonalNodeAlarm());


                        /* m[hǉEҏWE폜j[ǉ */
                        ((ActionNodeOperation) actionBuilderNodeOperation
                        .getActionNodeOperation()).setNodeInfo(targetNodeInfo);
                        manager.add(
                            actionBuilderNodeOperation.getActionNodeOperation());


                        
                        if(targetNodeInfo.getNodeKind().equals(NodeKind.CAMERA)) {
                        	/* Network Cameraj[ǉ */
                            ((ActionNetworkCamera) networkCameraAction.getActionNetworkCamera())
                            .setNodeInfo(targetNodeInfo);
                            manager.add(networkCameraAction.getActionNetworkCamera());
                        }
                    } else {
                        /* Groupłm[hłȂ */
                        nodeListTreeViewer.getTree().deselectAll();
                    }
                }
            } else {
                /* TreeI */
                manager.add(
                    actionBuilderNodeOperation.getActionNodeOperation());
            }
        }

        /* SNMPvr[\ */
        manager.add(snmpAction.getActionSnmpStatistics());

        /* Sm[hAlarmr[\ */
        manager.add(actinAlarm.getActionShowAllNodeAlarmListTable());
        /* m[hor[\ */
        manager.add(actionBuilderNodeDetect.getActionNodeDetectView());
    }

    /**
     * m[hTree View̑IXi[ݒ肵܂B
     *
     */
    protected void setupNodeTreeViewListener() {
        /*
         * Node Tree ViewɃXi[o^
         * Xi[̏ƂẮA
         * e[uViewɃtB[hꗗőIGg͒lƂĐݒ
         *
         */
        nodeListTreeViewer.addSelectionChangedListener(
            new ListenerNodeListTree(false));
    }
}
