/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.thread;

import java.util.logging.Logger;

import netjfwatcher.portscan.actions.PortScanTCPConnectionThread;
import netjfwatcher.portscan.thread.info.PortScanNodePort;
import netjfwatcher.portscan.view.PortScanEditorView;

/**
 * IɃL[`FbNAL[Ƀf[^PingĎs ThreadNXłB
 * 
 * @author Yoshimasa matsumoto
 * @version 1.0
 */
public class ThreadQueueCheckPortScan implements Runnable {
	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	/* MO */
	private static Logger logger = null;

	/**
	 * PingĎsThreadNXCX^X𐶐܂B
	 * 
	 */
	public ThreadQueueCheckPortScan() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * IɃL[`FbNAL[Ƀf[^Pings ܂B
	 */
	public void run() {

		// IɃL[`FbN[v
		while (!Thread.interrupted()) {

			PortScanNodePort portScanNodePort = PortScanQueue.getInstance()
					.popPortScanQueue();

			/*
			 * L[Ƀf[^Pings
			 */
			if (portScanNodePort != null) {
				/* Ďm[hIPAhXo */

				/*
				 * System.out.println("IP : " +
				 * portScanNodePort.getIpAddress()); System.out.println("Port : " +
				 * portScanNodePort.getPort()); System.out.println("Port Kind : " +
				 * portScanNodePort.getPortKind());
				 */
				if (portScanNodePort.getPortKind().equals(
						PortScanEditorView.TCP_DISCRIPTION)) {
					PortScanTCPConnectionThread tcpPortScan = new PortScanTCPConnectionThread();
					tcpPortScan.startTCPPortScan(portScanNodePort,
							portScanNodePort.getIpAddress(), portScanNodePort
									.getPort(), portScanNodePort.getTimeOut());
				}

			}

			try {
				Thread.sleep(WAIT_SLEEP_TIME);
			} catch (InterruptedException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}
	}
}
