/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.view;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.honeyport.actions.ActionBuilderHoneyPortScanTable;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;


public class HoneyPortScanTableView extends AbstractTableView {


	/* TrapMf[^\^C}[ */
	private static final int HONEY_PORT_TABLE_TIMER = 1000;

	private static boolean isCol0Direction = false;
	private static boolean isCol1Direction = true;
	private static boolean isCol2Direction = true;
	private static boolean isCol3Direction = true;
	private static boolean isCol4Direction = true;
	private static boolean isCol5Direction = true;


	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	private TableColumn col5;


	/* J */
	private static final float COLUMN0_NO = 0.05f;

	private static final float COLUMN1_IPADDRESS = 0.2f;

	private static final float COLUMN2_PORT = 0.2f;

	private static final float COLUMN3_START_DATE = 0.23f;

	private static final float COLUMN4_CHECK_DATE = 0.23f;

	private static final float COLUMN5_SCAN_COUNT = 0.1f;



	private Table table;

	private TableViewer viewer;


	private HoneyPortScanTableTimerProcessor timerProcessor;


	private SubStatusLineManager statusLineManager;


	private ActionBuilderHoneyPortScanTable actionHoneyPortReceiveTableBuilder;

	/* Display */
	private Display display;

	/**
	 * ANV\z܂B
	 * 
	 * @return actionBuilder ActionBuilder
	 */
	public ActionBuilderHoneyPortScanTable getActionBuilder() {
		return actionHoneyPortReceiveTableBuilder;
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
		setStatusLine();
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();

		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		viewer.setContentProvider(new HoneyPortScanTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new HoneyPortScanTableViewLabelProvider());

		/* ANV\z */
		actionHoneyPortReceiveTableBuilder = new ActionBuilderHoneyPortScanTable(
				display, viewer, table, statusLineManager);

		/* ReLXgj[AZbg */
		createContextMenu();

		/* ANV̏ */
		initActions();

		startTimer();
	}


	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_NO);
	}


	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_IPADDRESS);
	}


	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_PORT);
	}


	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3_START_DATE);
	}


	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4_CHECK_DATE);
	}


	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5_SCAN_COUNT);
	}


	
	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	private void createTable(Composite parent) {
		setStatusLine();

		table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);


		col0 = new TableColumn(table, SWT.LEFT);
		col0
				.setText(HoneyPortScanTableViewLabelProvider.COLUMNS[HoneyPortScanTableViewLabelProvider.NO]);
		col0.setWidth(computeCol0Width());

		col1 = new TableColumn(table, SWT.LEFT);
		col1
				.setText(HoneyPortScanTableViewLabelProvider.COLUMNS[HoneyPortScanTableViewLabelProvider.IP_ADDRESS]);
		col1.setWidth(computeCol1Width());


		col2 = new TableColumn(table, SWT.LEFT);
		col2
				.setText(HoneyPortScanTableViewLabelProvider.COLUMNS[HoneyPortScanTableViewLabelProvider.PORT]);
		col2.setWidth(computeCol1Width());


		col3 = new TableColumn(table, SWT.LEFT);
		col3
				.setText(HoneyPortScanTableViewLabelProvider.COLUMNS[HoneyPortScanTableViewLabelProvider.START_DATE]);
		col3.setWidth(computeCol1Width());


		col4 = new TableColumn(table, SWT.LEFT);
		col4
				.setText(HoneyPortScanTableViewLabelProvider.COLUMNS[HoneyPortScanTableViewLabelProvider.CHECK_DATE]);
		col4.setWidth(computeCol1Width());


		col5 = new TableColumn(table, SWT.LEFT);
		col5
				.setText(HoneyPortScanTableViewLabelProvider.COLUMNS[HoneyPortScanTableViewLabelProvider.CHECK_COUNT]);
		col5.setWidth(computeCol1Width());



		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {

					public void controlMoved(ControlEvent event) {
					}


					public void controlResized(ControlEvent event) {
						setResizedTableColumnWidth();
					}
				});


		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table,
						HoneyPortScanTableViewLabelProvider.NO, isCol0Direction);
			}
		});


		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol1Direction = sortTable(table,
						HoneyPortScanTableViewLabelProvider.IP_ADDRESS, isCol1Direction);
			}
		});


		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol2Direction = sortTable(table,
						HoneyPortScanTableViewLabelProvider.PORT,
						isCol2Direction);
			}
		});


		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol3Direction = sortTable(table,
						HoneyPortScanTableViewLabelProvider.START_DATE,
						isCol3Direction);
			}
		});

		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol4Direction = sortTable(table,
						HoneyPortScanTableViewLabelProvider.CHECK_DATE,
						isCol4Direction);
			}
		});


		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol5Direction = sortTable(table,
						HoneyPortScanTableViewLabelProvider.CHECK_COUNT,
						isCol5Direction);
			}
		});



	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());
				col5.setWidth(computeCol5Width());


			}
		}

	}

	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		manager.add(getActionBuilder().getActionRefreshPortScanTable());

	}

	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/* ReLXgj[̐AZbg */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}


	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		toolBarManager.add(getActionBuilder().getActionRefreshPortScanTable());


	}

	private void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);


	}

	private void startTimer() {

		HoneyPortScanTableTimerProcessor.getInstance().setDisplay(display);
		HoneyPortScanTableTimerProcessor.getInstance().setTable(table);
		timerProcessor = HoneyPortScanTableTimerProcessor.getInstance();
		display.timerExec(HONEY_PORT_TABLE_TIMER, timerProcessor);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
				timerProcessor);
	}
}
