/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.thread;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.honeyport.view.HoneyPortScanEditorView;

public final class HoneyUDPPortServer implements Runnable {
	// UDPMobt@TCY
	protected static final int RECEIVE_BUFF_SIZE = 8192;

	private byte receiveBuffer[];

	private DatagramPacket receivePacket;

	// MO
	private static Logger logger = null;

	private int count;

	private boolean isSetAlarm;

	private Date startDate;

	private Thread honeyUDPPortServerThread;

	/* ServerSocket */
	private DatagramSocket datagramSocket;

	public HoneyUDPPortServer() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	public void startUDPPortScanReceiveServer(int udpPort, boolean isSetAlarm)
			throws IOException {
		this.isSetAlarm = isSetAlarm;
		startDate = Calendar.getInstance().getTime();
		datagramSocket = new DatagramSocket(udpPort);
		logger.info("Create server socket : " + datagramSocket.getLocalPort());

		honeyUDPPortServerThread = new Thread(this);
		honeyUDPPortServerThread.setDaemon(true);
		honeyUDPPortServerThread.start();
	}

	public void stopUDPPortScanReceiveServer() {
		if (honeyUDPPortServerThread == null) {
			return;
		}

		// interrupt receive thread so it will die a natural death
		honeyUDPPortServerThread.interrupt();

		if (datagramSocket != null) {

			datagramSocket.close();

			/* Thread~܂Loop */
			while ((honeyUDPPortServerThread != null)
					&& honeyUDPPortServerThread.isAlive()) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}

			datagramSocket = null;
		}

		logger.info("UDP Port scan receive thread stop");
		honeyUDPPortServerThread = null;
	}

	public void run() {
		try {
			receiveBuffer = new byte[RECEIVE_BUFF_SIZE];
			receivePacket = new DatagramPacket(receiveBuffer, RECEIVE_BUFF_SIZE);
			while (true) {
				// ڑΎ󂯓

				datagramSocket.receive(receivePacket);

				int receiveLength = receivePacket.getLength();

				if (receiveLength <= 0) {
					continue;
				}

				String[] test = receivePacket.getSocketAddress().toString()
						.split(":");
				logger.info("Remote IP Address="
						+ receivePacket.getSocketAddress());
				String remoteIPAddress = test[0].substring(1, test[0].length());

				count++;

				logger.info("Connect remote IP Address : " + remoteIPAddress);
				logger.info("Client address = "
						+ datagramSocket.getLocalSocketAddress());
				logger.info("Client port = " + datagramSocket.getLocalPort());

				PortScanInfo portScanInfo = new PortScanInfo();
				portScanInfo.setCheckCount(count);
				portScanInfo.setIpAddress(remoteIPAddress);
				portScanInfo.setPort(datagramSocket.getLocalPort());
				portScanInfo.setPortKind(HoneyPortScanEditorView.UDP_DISCRIPTION);
				portScanInfo.setStartDate(startDate);
				Date date = Calendar.getInstance().getTime();
				portScanInfo.setCheckDate(date);
				PortScanMessageQueue.getInstance().pushPortScanInfo(
						portScanInfo);

				if (isSetAlarm) {
					AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake
							.getInstance();
					String message = remoteIPAddress + "/"
							+ datagramSocket.getLocalPort();
					alarmMessageMakeInstance.setHoneyPortScan(message);

				}

			}
		} catch (IOException ex) {

			if (datagramSocket.isClosed()) {
				logger.info("Server socket closed " + ex.getMessage());
			} else {
				logger.warning(ex.getMessage());
			}
		} finally {
			if (datagramSocket != null) {
				datagramSocket.close();
			}
		}
	}

	/**
	 * DatagramSocketclose܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws java.lang.Throwable {
		super.finalize();
		if (datagramSocket != null) {
			datagramSocket.close();
		}
	}
}
