/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.thread;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.honeyport.view.HoneyPortScanEditorView;

public final class HoneyTCPPortServer implements Runnable {
	// MO
	private static Logger logger = null;

	private int count;

	private boolean isSetAlarm;

	private Date startDate;

	private Thread honeyTcpPortServerThread;

	/* ServerSocket */
	private ServerSocket serverSocket;

	public HoneyTCPPortServer() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	public void startTCPPortScanReceiveServer(int tcpPort, boolean isSetAlarm)
			throws IOException {
		this.isSetAlarm = isSetAlarm;
		startDate = Calendar.getInstance().getTime();
		serverSocket = new ServerSocket(tcpPort);
		logger.info("Create server socket : " + serverSocket.getLocalPort());

		honeyTcpPortServerThread = new Thread(this);
		honeyTcpPortServerThread.setDaemon(true);
		honeyTcpPortServerThread.start();
	}

	public void stopTCPPortScanReceiveServer() {
		if (honeyTcpPortServerThread == null) {
			return;
		}

		// interrupt receive thread so it will die a natural death
		honeyTcpPortServerThread.interrupt();

		if (serverSocket != null) {
			try {
				serverSocket.close();
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}

			/* Thread~܂Loop */
			while ((honeyTcpPortServerThread != null)
					&& honeyTcpPortServerThread.isAlive()) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}

			serverSocket = null;
		}

		logger.info("TCP Port scan receive thread stop");
		honeyTcpPortServerThread = null;
	}

	public void run() {
		try {
			while (true) {
				// ڑΎ󂯓
				Socket socket = serverSocket.accept();

				count++;
				logger.info("Accept Address : "
						+ socket.getInetAddress().getHostAddress()
						+ " : port :" + socket.getLocalPort());

				// ڑIP Address
				String remoteIPAddress = socket.getInetAddress()
						.getHostAddress();
				logger.info("Connect remote IP Address : " + remoteIPAddress);
				logger.info("Client address = "
						+ socket.getLocalSocketAddress());
				logger.info("Client port = " + socket.getLocalPort());

				PortScanInfo portScanInfo = new PortScanInfo();
				portScanInfo.setCheckCount(count);
				portScanInfo.setIpAddress(remoteIPAddress);
				portScanInfo.setPort(socket.getLocalPort());
				portScanInfo.setPortKind(HoneyPortScanEditorView.TCP_DISCRIPTION);
				portScanInfo.setStartDate(startDate);
				Date date = Calendar.getInstance().getTime();
				portScanInfo.setCheckDate(date);
				PortScanMessageQueue.getInstance().pushPortScanInfo(
						portScanInfo);

				if (isSetAlarm) {
					AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake
							.getInstance();
					String message = remoteIPAddress + "/"
							+ socket.getLocalPort();
					alarmMessageMakeInstance.setHoneyPortScan(message);

				}

				try {
					if (socket != null) {
						socket.close();
					}
				} catch (IOException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

			}
		} catch (IOException ex) {

			if (serverSocket.isClosed()) {
				logger.info("Server socket closed " + ex.getMessage());
			} else {
				logger.warning(ex.getMessage());
			}
		} finally {

			if (serverSocket != null) {
				try {
					serverSocket.close();
				} catch (IOException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * ServerSocketclose܂B
	 *
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws java.lang.Throwable {
		super.finalize();
		if (serverSocket != null) {
			serverSocket.close();
		}
	}
}
