/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.actions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;

public class ActionBuilderHoneyPortScanTable {
	/** Timer~R[h */
	public static final int TIMER_STOP = -1;

	/* MO */
	private static Logger logger;

	protected DateFormat dateformat = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm:ss");

	private Display display;

	private final TableViewer viewer;

	private final Table trapTable;

	/* Xe[^XC}l[W */
	private final SubStatusLineManager statusLineManager;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	private final IAction refreshPortScanTableAction = new ActionRefreshPortScanTable();

	public ActionBuilderHoneyPortScanTable(final Display display,
			final TableViewer viewer, final Table table,
			final SubStatusLineManager statusLineManager) {
		logger = Logger.getLogger(this.getClass().getName());
		this.display = display;
		this.viewer = viewer;
		this.trapTable = table;
		this.statusLineManager = statusLineManager;
	}

	public IAction getActionRefreshPortScanTable() {
		return refreshPortScanTableAction;
	}

	private abstract class AbstractPortScanTableAction extends Action {

		public final void run() {
			doTask();
		}

		protected abstract void doTask();
	}

	private final class ActionRefreshPortScanTable extends
			AbstractPortScanTableAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/clear.gif"));
		}

		public String getText() {
			return "Clear honey port scan table";
		}

		public String getToolTipText() {
			return "Clear honey port scan table";
		}

		protected void doTask() {

			setPortScanTable();
		}
	}

	public void setPortScanTable() {
		/* e[ȗSč폜ătbV */
		trapTable.removeAll();
		viewer.refresh();

	}

}
