/*
 * Created on 2004/08/09
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.upload.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Logger;

import netjfwatcher.library.DataDisplay;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;


/**
 * NCAg̐ڑvɂNANCAgƂ̒ʐMp\bhy
 * NCAg̃R}hs\bhThreadNXłB
 *
 * Thread́ANCAgUploadwɂANCAgڑ҂|[
 * O[vN܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
class ThreadXMLSocketCommunicateClientConnect implements Runnable {
    /* NCAg̃R}hR[h */
    private static final String NODE_REGISTER = "NodeBundleRegister";

    /* Mobt@TCY */
    private static final int BUFF_LEN = 200;

    /* MO */
    private static Logger logger = null;

    /* Socket */
    private Socket xmlCommunicationSocket;

    /* Socket̓ǂݏoXg[ */
    private InputStream inStream;

    /**
     * NCAg̐ڑvɂ萶Socketp[^ƂāANCAgւ
     * CxgPUSHʒm邽߂̃CX^X𐶐܂B<BR>
     *
     * CX^Xɂ킹ēo̓Xg[𐶐܂B<BR>
     *
     * @param socket Socket
     * @throws IOException SocketInputStream擾Ɏsꍇ
     */
    protected ThreadXMLSocketCommunicateClientConnect(Socket socket)
        throws IOException {
        super();
        logger = Logger.getLogger(this.getClass().getName());

        xmlCommunicationSocket = socket;
        inStream = xmlCommunicationSocket.getInputStream();
    }

    /**
     * NCAgւ̃CxgPUSHʒmp̃XbhJn܂B<BR>
     * iNCAg̐ڑ҂[vĂ΂܂j<BR>
     *
     * @param remoteip NCAgIPAhX
     */
    public void startXmlSocketThread(String remoteip) {
        Thread xmlSocketThread = new Thread(this);
        xmlSocketThread.setName(xmlSocketThread + " : " + remoteip);
        xmlSocketThread.start();
    }

    /**
     * NCAgւ̃CxgPUSHʒmp̃XbhłB<BR>
     * ؒf܂Ŗ[vœ삵܂B
     */
    public void run() {
        try {
            /*
             * NCAg֒IɐڑmFpf[^𑗐MAڑ󋵂mF
             */
            this.receiveCommandFromClient();
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }

            if (xmlCommunicationSocket != null) {
                try {
                    xmlCommunicationSocket.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }

        logger.info("Disconnected");
    }

    /**
     * NCAgؒf܂Ŗ[vœ삷ƂƂɁANCAg
     * IɐڑmFpf[^𑗐MAڑ󋵂mF܂B
     * ́ANCAguEȔIȂǂ\IɌo邽߂ɍs܂B
     *
     */
    private void receiveCommandFromClient() {
        // NCAgXMLf[^͂ăR}hR[h𒊏o
        String commandCode = getCommandCode();

        if ((commandCode != null) && commandCode.equals(NODE_REGISTER)) {
            /* m[hꊇo^ */
            NodeBundleRegister registerNodeBundle = new NodeBundleRegister();

            try {
                registerNodeBundle.registerNode(
                    NodeRegisterQueue.getInstance().getNodeInfoList(),
                    NodeRegisterQueue.getInstance().getLinkList());
                registerNodeBundle.communicateClient(xmlCommunicationSocket);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
            } catch (SocketException e) {
                logger.warning("Client disconnect");
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * MXMLf[^R}hR[h𒊏oāAԂ܂B
     *
     * @return commandCode R}hR[h
     */
    private String getCommandCode() {
        byte[] buf = new byte[BUFF_LEN];

        String commandCode = "";
        InputStream inbuff = null;
        int len = 0;

        try {
            len = inStream.read(buf);

            inbuff = new ByteArrayInputStream(buf, 0, len - 1);

            // XMLf[^IPAhX𒊏o
            commandCode = this.getDocument(inbuff);
        } catch (IOException e) {
            logger.warning(
                " Buffer Receive Data : "
                + DataDisplay.hexBytetoString(buf, len));
            logger.warning("buffer len : " + len);
            logger.warning(e.getMessage());
            e.printStackTrace();
        } finally {
            try {
                inbuff.close();
            } catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }

        return commandCode;
    }

    /**
     * ̓Xg[XML͂AbZ[W񑮐𒊏oA̕Ԃ܂B
     * ܂AMf[^ȉ̏ꍇɂ́AڑNCAgփf[^𑗐M܂B
     * EA[eXgp
     * E`bgp
     *
     * @param inbuff Socket̓ǂݏoXg[
     * @return filterDate R}hR[h
     */
    private String getDocument(InputStream inbuff) {
        if (inbuff == null) {
            return null;
        }

        Document doc = null;

        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(inbuff);
        } catch (JDOMException e) {
            e.printStackTrace();

            return null;
        } catch (IOException e) {
            e.printStackTrace();

            return null;
        }

        // R}hvfo
        Element root = doc.getRootElement();
        String filterDate = root.getAttributeValue("command");

        return filterDate;
    }
}
