/*
 * Created on 2004/08/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.upload.model;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Logger;

import netjfwatcher.resourceconfig.EngineResourceConfig;


/**
 * FlashNCAgƂXML SocketڑThread𐧌䂷VOgNXłB
 * NCAgUploadwɂAXML\Pbgڑ҂XML Socket\Pbg
 * A|[O[vɂăNCAg̐ڑ҂XbhJn܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ServerXMLSocketCommunicate implements Runnable {
    /* MO */
    private static Logger logger = null;

    /* NCAg̐ڑ҂Xbh */
    private static Thread thread = null;

    /* NCAgXML\Pbgڑ҂ServerSocket */
    private ServerSocket server;

    /* ClientƂ̒ʐMp|[g */
    private int clientConnectPort;

    private ServerXMLSocketCommunicate() {
        logger = Logger.getLogger(this.getClass().getName());

        // ClientƂ̒ʐMp̃|[gԍ\[Xt@C擾
        String clientXmlSocketPort =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getClientXmlSocketPort();
        clientConnectPort = Integer.parseInt(clientXmlSocketPort);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ServerXMLSocketCommunicate getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * NCAgXML\Pbgڑ҂XML Socket\Pbg𐶐A|[O[vɂ
     * NCAg̐ڑ҂XbhJn܂B<BR>
     */
    public void startThread() {
        if (thread == null) {
            thread = new Thread(SingletonResource.RESOURCE);

            // t.setDaemon(true);
            thread.start();
        }
    }

    /**
     * ServerSocket̃CX^X𐶐ANCAg̐ڑ҂[vɓB<BR>
     * NCAg̐ڑ󂯓ƁAT[oNCAgւ̃CxgPUSHʒm̂
     * Xbh𐶐܂B<BR>
     */
    public void run() {
        try {
            /*
             * T[o[\Pbg𐶐ANCAgXML\Pbgڑ҂|[O[vɓ
             */
            server = new ServerSocket(clientConnectPort);
            logger.info("Create Server Socket = " + server.getLocalPort());

            while (true) {
                //  ڑΎ󂯓
                Socket socket = server.accept();
                logger.info(
                    "Accept Address = " + socket.getInetAddress().toString()
                    + " , port = " + socket.getLocalPort());

                socket.setKeepAlive(true);

                // ڑIP Address
                String remoteip = socket.getInetAddress().toString();
                logger.info("Connect remote IP = " + remoteip);

                // 󂯓ꂽڑpXbh𐶐
                ThreadXMLSocketCommunicateClientConnect xmlthread =
                    new ThreadXMLSocketCommunicateClientConnect(socket);

                // XbhJn
                xmlthread.startXmlSocketThread(remoteip);
            }
        } catch (SocketException e) {
            e.printStackTrace();
            logger.warning(e.getMessage());
        } catch (IOException ex) {
            ex.printStackTrace();
            logger.warning(ex.getMessage());
        } finally {
            if (server != null) {
                try {
                    server.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();
        server.close();
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ServerXMLSocketCommunicate RESOURCE =
            new ServerXMLSocketCommunicate();
    }
}
