/*
 * Created on 2004/08/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.test.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionResourceGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * WebAvP[VNɂāAGWғ󋵂`FbN郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TestNetWatch {
    private static Logger logger;

    public TestNetWatch() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWƂ̐ڑmF܂B
     *
     * @param engineAddress GWAhX
     * @throws EngineConnectException GWƂ̐ڑɎsꍇ
     * @throws IOException GWƂ̒ʐMɈُ킪
     */
    public void testEngine(String engineAddress)
        throws EngineConnectException, IOException {
        // GWڑeXg
        // NG̏ꍇException
        if (engineAddress.equals("all")) {
            boolean isTestResult = false;
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            String engineCheckAddress = "";
            String engineCheckPort = "";
            StringBuffer result = new StringBuffer();

            for (int i = 0; i < engineList.size(); i++) {
                engineCheckAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
                engineCheckPort =
                    ((EngineResourceInfo) engineList.get(i)).getEnginePort();

                ConnectionResourceGet resourceGet =
                    new ConnectionResourceGet(engineCheckAddress);

                try {
                    ResourceInfo resourceInfo = resourceGet.getResource();
                    isTestResult = true;

                    break;
                } catch (EngineConnectException e) {
                    logger.warning(
                        "Engine connect abort (" + e.getMessage() + ")");
                    result.append(
                        "Engine IP=" + engineCheckAddress + " connect abort ("
                        + e.getMessage() + ")");
                } catch (IOException e) {
                    logger.warning(
                        "Engine connect abort (" + e.getMessage() + ")");
                    result.append(
                        "Engine IP=" + engineCheckAddress + " connect abort ("
                        + e.getMessage() + ")");
                }
            }

            if (!isTestResult) {
                throw new EngineConnectException(result.toString());
            } else {
                logger.info("Engine connect good : " + engineCheckAddress);
            }
        } else {
            ConnectionResourceGet resourceGet =
                new ConnectionResourceGet(engineAddress);
            ResourceInfo resourceInfo = resourceGet.getResource();
            logger.info(
                "Engine connect good. Database name is "
                + resourceInfo.getDatabaseName());
        }
    }

    /**
     * GWƂ̐ڑmF܂B
     *
     * @return GWڑeXgʕ
     */
    public String testEngine() {
        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        String engineCheckAddress = "";
        String engineCheckPort = "";
        StringBuffer result = new StringBuffer();

        for (int i = 0; i < engineList.size(); i++) {
            engineCheckAddress =
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
            engineCheckPort =
                ((EngineResourceInfo) engineList.get(i)).getEnginePort();

            ConnectionResourceGet resourceGet =
                new ConnectionResourceGet(engineCheckAddress);

            try {
                ResourceInfo resourceInfo = resourceGet.getResource();
                result.append(
                    engineCheckAddress + " connect ok."
                    + System.getProperty("line.separator"));
            } catch (EngineConnectException e) {
                result.append(
                    engineCheckAddress + " connect abort (" + e.getMessage()
                    + ")" + System.getProperty("line.separator"));
            } catch (IOException e) {
                result.append(
                    engineCheckAddress + " connect abort (" + e.getMessage()
                    + ")" + System.getProperty("line.separator"));
            }
        }

        return result.toString();
    }
}
