/*
 * Created on 2004/07/31
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.struts.model.biz;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;


/**
 * SystemExceptionHandlerNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SystemExceptionHandler extends ExceptionHandler {
    private static Logger logger = null;

    public ActionForward execute(
        Exception e, ExceptionConfig config, ActionMapping mapping,
        ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String errorMessage = "Unknown error.";

        if ((e != null) && (e.getLocalizedMessage() != null)) {
            errorMessage = e.getLocalizedMessage();
        }

        request.setAttribute("errorMessege", errorMessage);

        ActionForward actionForward =
            super.execute(e, config, mapping, form, request, response);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);

        if ((e != null) && (e.getLocalizedMessage() != null)) {
            logger.warning(e.getMessage());
            logger.warning(sw.toString());

            e.printStackTrace(pw);
        }

        // log.fatal(sw);
        return actionForward;
    }
}
