/*
 * Created on 2003/08/17
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.statisticsmib.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.EngineConnectException;


/**
 * SNMPvWݒݒAҏWyэ폜郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsSetModel {
    private static Logger logger = null;

    public StatisticsSetModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMPvCݒݒ肵܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hAhX
     * @param community ReadR~jeB
     * @param oid OID
     * @param snmpPeriod ̎
     * @param threshold Ď臒l
     * @param thresholdtype 臒lĎ^Cv
     * @return ݒ茋
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public boolean setStatisticsMibInfo(
        String engineAddress, String ipaddress, String community, String oid,
        String snmpPeriod, String threshold, String thresholdtype)
        throws EngineConnectException, IOException {
        StatisticsSet statisticsset = new StatisticsSet(ipaddress);
        statisticsset.setStatisticsMIBInfo(
            engineAddress, ipaddress, community, oid, snmpPeriod, threshold,
            thresholdtype);

        return true;
    }

    /**
     * SNMPvWݒҏW܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hAhX
     * @param community ReadR~jeB
     * @param oid OID
     * @param snmpPeriod ̎
     * @param threshold Ď臒l
     * @param thresholdtype 臒lĎ^Cv
     * @return ݒ茋
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public boolean editStatisticsMibInfo(
        String engineAddress, String ipaddress, String community, String oid,
        String snmpPeriod, String threshold, String thresholdtype)
        throws EngineConnectException, IOException {
        StatisticsSet statisticsset = new StatisticsSet(ipaddress);
        statisticsset.editStatisticsMIBInfo(
            engineAddress, ipaddress, community, oid, snmpPeriod, threshold,
            thresholdtype);

        return true;
    }

    /**
     * SNMPvWݒ폜܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hAhX
     * @param community ReadR~jeB
     * @param oid OID
     * @param snmpPeriod ̎
     * @param threshold Ď臒l
     * @param thresholdtype 臒lĎ^Cv
     * @return ݒ茋
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public boolean deleteStatisticsMibInfo(
        String engineAddress, String ipaddress, String community, String oid,
        String snmpPeriod, String threshold, String thresholdtype)
        throws EngineConnectException, IOException {
        StatisticsSet statisticsset = new StatisticsSet(ipaddress);
        statisticsset.deleteStatisticsMIBInfo(
            engineAddress, ipaddress, community, oid, snmpPeriod, threshold,
            thresholdtype);

        return true;
    }

    /**
     * SNMPvWݒ񃊃XgԂ܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hAhX
     * @return@statisticsMIBSetList vWݒ񃊃Xg
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getStatisticsMibInfoList(
        String engineAddress, String ipaddress)
        throws EngineConnectException, IOException {
        ArrayList statisticsMIBSetList = null;

        StatisticsSet statisticsset = new StatisticsSet(ipaddress);
        statisticsMIBSetList =
            statisticsset.getStatisticsMIBInfoList(engineAddress, ipaddress);

        return statisticsMIBSetList;
    }
}
