/*
 * Created on 2003/08/17
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.statisticsmib.model;

import java.io.IOException;
import java.util.ArrayList;

import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.ConnectionStatisticsMibSet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.MibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;


/**
 * m[hSNMPvMIB̎ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsSet {
    /* m[hIPAhX */
    private String ipaddress;

    public StatisticsSet(final String _ipaddress) {
        this.ipaddress = _ipaddress;
    }

    /**
     * GWSNMPvMIB̎̐ݒs܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIPAhX
     * @param community SNMPR~jeB
     * @param oid OID
     * @param snmpPeriod SNMP̎
     * @param threshold vMIB臒l
     * @param thresholdtype vMIB臒lĎ^Cv
     * @throws EngineConnectException GWƂ̒ʐMɎsꍇ
     * @throws IOException GWƂ̒ʐMɈُ킪ꍇ
     */
    public void setStatisticsMIBInfo(
        String engineAddress, String ipaddress, String community, String oid,
        String snmpPeriod, String threshold, String thresholdtype)
        throws EngineConnectException, IOException {
        /* GWɓv̎OID̒ʒms */
        ConnectionStatisticsMibSet mibStatistics =
            new ConnectionStatisticsMibSet(engineAddress);
        MibInfo mibInfo = new MibInfo();

        mibInfo.setVersion(0);
        mibInfo.setRoCommunity(community);
        mibInfo.setRwCommunity(community);
        mibInfo.setRequestMibOid(oid);
        mibInfo.setPeriod(snmpPeriod);
        mibInfo.setThreshHold(threshold);
        mibInfo.setThreshHoldType(thresholdtype);

        mibStatistics.setStatisticsMibSet(ipaddress, mibInfo);
    }

    /**
     * GWSNMPvMIB̎̐ݒ̕ύXs܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress IPAhX
     * @param community SNMPR~jeB
     * @param oid OID
     * @param snmpPeriod SNMP̎
     * @param threshold vMIB臒l
     * @param thresholdtype vMIB臒lĎ^Cv
     * @throws EngineConnectException GWƂ̒ʐMɎsꍇ
     * @throws IOException GWƂ̒ʐMɈُ킪ꍇ
     */
    public void editStatisticsMIBInfo(
        String engineAddress, String ipaddress, String community, String oid,
        String snmpPeriod, String threshold, String thresholdtype)
        throws EngineConnectException, IOException {
        /* GWɓv̎OID̒ʒms */
        ConnectionStatisticsMibSet connection =
            new ConnectionStatisticsMibSet(engineAddress);
        MibInfo mibInfo = new MibInfo();

        mibInfo.setVersion(0);
        mibInfo.setRoCommunity(community);
        mibInfo.setRwCommunity(community);
        mibInfo.setRequestMibOid(oid);
        mibInfo.setPeriod(snmpPeriod);
        mibInfo.setThreshHold(threshold);
        mibInfo.setThreshHoldType(thresholdtype);
        connection.editStatisticsMibSet(ipaddress, mibInfo);
    }

    /**
     * GWSNMPvMIB̖̎̐ݒs܂B
     *
     * @param engineAddress GWAhX
     * @param _ipaddress m[hIPAhX
     * @param community SNMP ReadR~jeB
     * @param oid OID
     * @param snmpPeriod SNMP̎
     * @param threshold vMIB臒l
     * @param thresholdtype vMIB臒lĎ^Cv
     * @throws EngineConnectException GWƂ̒ʐMɎsꍇ
     * @throws IOException GWƂ̒ʐMɈُ킪ꍇ
     */
    public void deleteStatisticsMIBInfo(
        String engineAddress, String _ipaddress, String community, String oid,
        String snmpPeriod, String threshold, String thresholdtype)
        throws EngineConnectException, IOException {
        /* GWɓv̎OID̍폜ʒms */
        ConnectionStatisticsMibSet connection =
            new ConnectionStatisticsMibSet(engineAddress);
        MibInfo mibInfo = new MibInfo();

        mibInfo.setVersion(0);
        mibInfo.setRoCommunity(community);
        mibInfo.setRwCommunity(community);
        mibInfo.setRequestMibOid(oid);
        mibInfo.setPeriod(snmpPeriod);
        mibInfo.setThreshHold(threshold);
        mibInfo.setThreshHoldType(thresholdtype);
        connection.deleteStatisticsMibSet(ipaddress, mibInfo);
    }

    /**
     * SNMPv̎ݒ擾܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIPAhX
     * @return mibSetList vMIB̎ݒ茋ʃXg
     * @throws EngineConnectException GWƂ̐ڑňُoꍇ
     * @throws IOException GWƂ̐ڑňُoꍇ
     */
    public ArrayList getStatisticsMIBInfoList(
        String engineAddress, String ipaddress)
        throws EngineConnectException, IOException {
        StatisticsMibControl control = new StatisticsMibControl();
        control.setSubCommand(StatisticsMibControl.STATISTICS_SET_STATUS_GET);
        control.setIpaddress(ipaddress);

        ConnectionStatisticsMibGet statisticsMibGet =
            new ConnectionStatisticsMibGet(engineAddress);
        StatisticsMibProperty mibproperty =
            statisticsMibGet.getStatisticsMib(control);
        ArrayList mibSetList = null;

        if (mibproperty != null) {
            mibSetList = mibproperty.getStatisticsMibSetList();
        }

        return mibSetList;
    }
}
