/*
 * Created on 2003/08/19
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.statisticsmib.action;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.statisticsmib.model.StatisticsSetModel;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * SNMPvMIB̎ݒԂ\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsSetStateAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not engine address : " + engineAddress);
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);
        String community = "";

        NodeRegisterModel nodeinfo = new NodeRegisterModel();
        NodeInformation nodeInfo =
            nodeinfo.getIPTarget(engineAddress, ipaddress);

        if (nodeInfo != null) {
            community = nodeInfo.getRoCommunity();
        }

        StatisticsSetModel statisset = new StatisticsSetModel();
        ArrayList statisticsList = statisset.getStatisticsMibInfoList(engineAddress, ipaddress);
        request.setAttribute(
            Preference.SNMP_STATISTICS_MIBSET_LIST, statisticsList);
        request.setAttribute(
            Preference.SNMP_STATISTICS_TARGET_IPADDRESS, ipaddress);
        request.setAttribute(Preference.SNMP_READ_COMMUNITY, community);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');
        String convIPAddress = ipaddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
