/*
 * Created on 2003/08/21
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.resourceconfig;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.preference.Preference;

import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;


/**
 * GW̐ڑ񃊃\[Xt@C͂āAێNXłB
 *
 * EGWIPAhX
 * EGWƂ̐ڑPort
 *
 * @author Yoshimasa Matsumoto
 * @version .10
 */
public class EngineResourceConfigFileParse {
    /* GWڑ^CAEgftHgl */
    private static final String ENGINE_TIMEOUT_DEFAULT = "0";

    /* conf TAG */
    private static final String CONF_TAG = "conf";

    /* Engine TAG */
    private static final String ENGINE_TAG = "engine";

    /* GWIP Address TAG */
    private static final String ENGINE_IPADDRESS_TAG = "ipaddress";

    /* GWR}hPort TAG */
    private static final String ENGINE_PORT_TAG = "port";

    /* Timeout TAG */
    private static final String ENGINE_TIMEOUT_TAG = "timeout";

    /* XML Scoketڑ|[g TAG */
    private static final String ENGINE_XML_SOCKET_PORT_TAG = "xmlSocketPort";

    /* Client TAG */
    private static final String CLIENT_TAG = "client";

    /* Node Register Status Report Port */
    private static final String NODE_REGISTER_PORT_TAG = "xmlSocketReportPort";

    /* l */
    private static final String ATTRIBUTE_VALUE = "value";

    /* Logging */
    private static Logger logger = null;

    /* GW\[X񃊃Xg */
    private ArrayList engineInfoList = new ArrayList();

    /* ڑGWIPAhX */
    private String engineIPAddress;

    /* GWƐڑ|[g */
    private String enginePort;

    /* GWƂ̐ڑ^CAEgl */
    private String engineTimeout;

    /* Flash ClientƃGWXML Socketڑ|[g */
    private String engineFlashXMLSocketPort;

    /* Flash ClientWebAvԂł̃m[hꊇo^󋵕񍐗pڑ|[g */
    private String clientXmlSocketPort;

    /**
     * GW̐ڑ񃊃\[XXMLt@C͂܂B
     *
     */
    public EngineResourceConfigFileParse() {
        logger = Logger.getLogger(this.getClass().getName());

        Document doc = null;

        try {
            /* bZ[W\[Xt@C */
            ClassLoader loader =
                EngineResourceConfigFileParse.class.getClassLoader();
            URL url = loader.getResource(Preference.ENGINE_XML_FILE);

            if (url == null) {
                logger.severe("Engine Resource XML file url : " + url);
            }

            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        } catch (JDOMException e) {
            e.printStackTrace();
        } catch (NullPointerException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        try {
            // rootvfo
            Element root = doc.getRootElement();

            try {
                List targetList = root.getChildren(ENGINE_TAG);

                int targetCount = 0;
                Iterator iterator0 = targetList.iterator();

                while (iterator0.hasNext()) {
                    try {
                        EngineResourceInfo engineInfo =
                            new EngineResourceInfo();

                        targetCount++;

                        Element targetListEl = (Element) iterator0.next();

                        /* Engine IP Address */
                        engineIPAddress =
                            (targetListEl.getChild(ENGINE_IPADDRESS_TAG))
                            .getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEngineIPaddress(engineIPAddress);

                        /* Engine Port */
                        enginePort =
                            (targetListEl.getChild(ENGINE_PORT_TAG))
                            .getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEnginePort(enginePort);

                        /* Engine Timeout */
                        if (targetListEl.getChild(ENGINE_TIMEOUT_TAG) != null) {
                            engineTimeout =
                                (targetListEl.getChild(ENGINE_TIMEOUT_TAG))
                                .getAttributeValue(ATTRIBUTE_VALUE);

                            engineInfo.setEngineTimeout(engineTimeout);
                        } else {
                            engineInfo.setEngineTimeout(ENGINE_TIMEOUT_DEFAULT);
                        }

                        /* Flash XML Socket Port */
                        engineFlashXMLSocketPort =
                            (targetListEl.getChild(ENGINE_XML_SOCKET_PORT_TAG))
                            .getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEngineFlashXMLSocketPort(
                            engineFlashXMLSocketPort);

                        engineInfoList.add(engineInfo);
                    } catch (NullPointerException e) {
                        e.printStackTrace();
                        logger.warning(
                            "Abort Engine XML File parse at target No."
                            + targetCount);
                    }
                }
            } catch (NullPointerException e) {
                logger.warning("NullPointerException " + e.getMessage());
                e.printStackTrace();
            }

            /*
             * Client xml socket connect
             * Node Register Status Report Port
             */
            Element clientEl = root.getChild(CLIENT_TAG);
            clientXmlSocketPort =
                (clientEl.getChild(NODE_REGISTER_PORT_TAG)).getAttributeValue(
                    ATTRIBUTE_VALUE);
        } catch (NullPointerException e) {
            logger.warning("NullPointerException " + e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * GWIPAhXԂ܂B
     *
     * @return engineIPAddress GWIPAhX
     */
    public String getEngineIPAddress() {
        return engineIPAddress;
    }

    /**
     * Flash ClientWebAvԂł̃m[hꊇo^󋵕񍐗p
     * ڑ|[gԂ܂B
     *
     * @return clientXmlSocketPort Flash ClientWebAv
     * ł̃m[hꊇo^󋵕񍐗pڑ|[g
     */
    public String getClientXmlSocketPort() {
        return clientXmlSocketPort;
    }

    /**
     * GW\[X񃊃XgԂ܂B
     *
     * @return engineInfoList GW\[X񃊃Xg
     */
    public ArrayList getEngineInfoList() {
        return engineInfoList;
    }

    /**
     * GW\[XXV܂B
     *
     * @param engineInfoList GW񃊃Xg
     * @param xmlSocketReportPort Flash Abv[hԒʒm|[g
     */
    public void updateEngineResource(
        ArrayList engineInfoList, String xmlSocketReportPort) {
        // VXe\[XXV
        Document dom = this.updateDocument(engineInfoList, xmlSocketReportPort);
        BufferedWriter bufWriter = getResourceFileWriter();

        if ((dom != null) && (bufWriter != null)) {
            // XMLt@Co
            this.outputXMLFile(bufWriter, dom);
        }
    }

    /*
     * \[X񂩂Document𐶐AԂ܂B
     *
     * @param updateEngineInfoList GWڑ񃊃Xg
     * @param updateXMLSocketReportPort m[hꊇo^ԕ񍐃|[g
     * @return Document
     */
    private Document updateDocument(
        ArrayList updateEngineInfoList, String updateXMLSocketReportPort) {
        Element confElement = new Element(CONF_TAG);
        Document doc = new Document(confElement);

        if (updateEngineInfoList == null) {
            return null;
        }

        // Engine Connect Rg
        confElement.addContent(new Comment("Engine Communication Information"));

        EngineResourceInfo engineInfo = null;

        for (int i = 0; updateEngineInfoList.size() > i; i++) {
            engineInfo = (EngineResourceInfo) updateEngineInfoList.get(i);

            if (engineInfo == null) {
                logger.warning("Not found Engine Config at index=" + i);

                break;
            }

            Element engineEl = new Element(ENGINE_TAG);
            confElement.addContent(engineEl);

            Element ipAddressEl = new Element(ENGINE_IPADDRESS_TAG);
            engineEl.addContent(ipAddressEl);

            Element enginePortEl = new Element(ENGINE_PORT_TAG);
            engineEl.addContent(enginePortEl);

            Element engineTimeoutEl = new Element(ENGINE_TIMEOUT_TAG);
            engineEl.addContent(engineTimeoutEl);

            Element xmlSocketPortEl = new Element(ENGINE_XML_SOCKET_PORT_TAG);
            engineEl.addContent(xmlSocketPortEl);

            ipAddressEl.setAttribute(
                new Attribute(ATTRIBUTE_VALUE, engineInfo.getEngineIPaddress()));
            enginePortEl.setAttribute(
                new Attribute(ATTRIBUTE_VALUE, engineInfo.getEnginePort()));

            if (engineInfo.getEngineTimeout() != null) {
                engineTimeoutEl.setAttribute(
                    new Attribute(
                        ATTRIBUTE_VALUE, engineInfo.getEngineTimeout()));
            }

            xmlSocketPortEl.setAttribute(
                new Attribute(
                    ATTRIBUTE_VALUE, engineInfo.getEngineFlashXMLSocketPort()));
        }

        Element clientEl = new Element(CLIENT_TAG);

        // Node Register Status Report Port Rg
        clientEl.addContent(new Comment("Node Register Status Report Port"));
        confElement.addContent(clientEl);

        Element xmlSocketReportPortEl = new Element(NODE_REGISTER_PORT_TAG);
        clientEl.addContent(xmlSocketReportPortEl);

        if (updateXMLSocketReportPort != null) {
            xmlSocketReportPortEl.setAttribute(
                new Attribute(ATTRIBUTE_VALUE, updateXMLSocketReportPort));
            clientXmlSocketPort = updateXMLSocketReportPort;
        }

        engineInfoList = updateEngineInfoList;

        return doc;
    }

    /*
     * GW\[XBufferedWriterԂ܂B
     *
     * @return bufferedWriter BufferedWriter
     */
    private BufferedWriter getResourceFileWriter() {
        ClassLoader loader =
            EngineResourceConfigFileParse.class.getClassLoader();
        URL url = loader.getResource(Preference.ENGINE_XML_FILE);

        if (url == null) {
            logger.warning("Engine XML File URL null.");

            return null;
        }

        BufferedWriter bufferedWriter = null;

        logger.info("File url path=" + url.getPath());
        System.out.println("File url path=" + url.getPath());

        String newPath = url.getPath().replaceAll("%20", " ");
        System.out.println("File url replace path=" + newPath);

        try {
            FileWriter fi = new FileWriter(newPath);
            bufferedWriter = new BufferedWriter(fi);
        } catch (IOException e1) {
            logger.warning(
                "Error Engine XML File FileWriter URL Path = " + url.getPath()
                + " " + e1.getMessage());
            e1.printStackTrace();

            return null;
        }

        return bufferedWriter;
    }

    /*
     * wBufferedWriterɎwDocumento͂܂B
     *
     * @param bufWriter BufferedWriter
     * @param dom Document
     */
    private void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        /*
         * qGgeGg2wAGgԂ̉sw͂Ȃ
         * iXMLt@CŌXsĂ邽߁j
         * XMLOutputter outputter = new XMLOutputter("  ", true);
         */
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        FileWriter writer = null;

        try {
            outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}
