/*
 * Created on 2003/08/20
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview.gpaph;

import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hr[ɂSNMPvMIBOt\sANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeViewStatisticsMibGraph extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "localhost";
            logger.warning("Not engine address : " + engineAddress);
        }

        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);
        String oid = request.getParameter(Preference.SNMP_OID);
        String instance = request.getParameter(Preference.SNMP_OID_INSTANCE);

        request.setAttribute(Preference.IPADDRESS, nodeIPAddress);
        request.setAttribute(Preference.SNMP_OID, oid);
        request.setAttribute(Preference.SNMP_OID_INSTANCE, instance);

        String convIPAddress = nodeIPAddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
