/*
 * Created on 2004/04/21
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hĎ\\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeConfigInformationAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);
        NodeRegisterModel noderegister = new NodeRegisterModel();
        NodeInformation nodeInfo =
            noderegister.getIPTarget(engineAddress, ipaddress);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        // NodeRegister nodeinfo = (NodeRegister) list.get(0);
        if (
            nodeInfo.getSnmpLevel().equals(
                    SnmpPreference.SNMP_LEVEL0_CODE_STRING)) {
            nodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL0_DESCRIPTION);
        } else if (
            nodeInfo.getSnmpLevel().equals(
                    SnmpPreference.SNMP_LEVEL1_CODE_STRING)) {
            nodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL1_DESCRIPTION);
        } else if (
            nodeInfo.getSnmpLevel().equals(
                    SnmpPreference.SNMP_LEVEL2_CODE_STRING)) {
            nodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL2_DESCRIPTION);
        } else if (
            nodeInfo.getSnmpLevel().equals(
                    SnmpPreference.SNMP_LEVEL3_CODE_STRING)) {
            nodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL3_DESCRIPTION);
        } else if (
            nodeInfo.getSnmpLevel().equals(
                    SnmpPreference.SNMP_LEVEL4_CODE_STRING)) {
            nodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL4_DESCRIPTION);
        }

        String convIPAddress = ipaddress.replace('.', '_');
        request.setAttribute(Preference.NODE_REGISTER_INFO, nodeInfo);
        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.SERVER_NAME, servername);

        return mapping.findForward(Preference.SUCCESS);
    }
}
